/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.proxy;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanAssetHelper;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.internal.datastore.ConanUrlIndexer;
import com.sonatype.repository.conan.internal.datastore.proxy.ConanProxyHelper;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
public class ConanProxyFacet
extends ProxyFacetSupport {
    private final ConanUrlIndexer conanUrlIndexer;

    @Inject
    public ConanProxyFacet(ConanUrlIndexer conanUrlIndexer) {
        this.conanUrlIndexer = conanUrlIndexer;
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coords = ConanProxyHelper.convertFromState(state);
        Optional<Content> optionalContent = ((ConanContentFacet)this.facet(ConanContentFacet.class)).getAsset(coords, assetKind).map(FluentAsset::download);
        if (optionalContent.isPresent() && (assetKind.equals((Object)AssetKind.DOWNLOAD_URL) || assetKind.equals((Object)AssetKind.DIGEST))) {
            Content content = optionalContent.get();
            Content updatedContent = new Content((Payload)new StringPayload(this.conanUrlIndexer.updateAbsoluteUrls(context, content, this.getRepository()), "application/json"));
            this.copyAttributes(content.getAttributes(), updatedContent.getAttributes());
            return updatedContent;
        }
        return optionalContent.orElse(null);
    }

    private void copyAttributes(AttributesMap source, AttributesMap destination) {
        source.entries().forEach(kv -> {
            Object object = destination.set((String)kv.getKey(), kv.getValue());
        });
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords conanCoords = ConanProxyHelper.convertFromState(state);
        if (assetKind.equals((Object)AssetKind.CONAN_PACKAGE)) {
            return this.putPackage(content, conanCoords, assetKind);
        }
        return this.putMetadata(context, content, assetKind, conanCoords);
    }

    private Content putPackage(Content content, ConanCoords coords, AssetKind assetKind) {
        return ((ConanContentFacet)this.facet(ConanContentFacet.class)).putPackage((Payload)content, coords, assetKind).download();
    }

    private Content putMetadata(Context context, Content content, AssetKind assetKind, ConanCoords coords) throws IOException {
        if (assetKind == AssetKind.DOWNLOAD_URL || assetKind == AssetKind.DIGEST) {
            Content saveMetadata = this.doSaveMetadata(assetKind, coords, content);
            return new Content((Payload)new StringPayload(this.conanUrlIndexer.updateAbsoluteUrls(context, saveMetadata, this.getRepository()), "application/json"));
        }
        return this.doSaveMetadata(assetKind, coords, content);
    }

    protected Content doSaveMetadata(AssetKind assetKind, ConanCoords coords, Content content) {
        return ((ConanContentFacet)this.facet(ConanContentFacet.class)).putMetadata((Payload)content, coords, assetKind).map(FluentAsset::download).orElse(null);
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) {
    }

    protected String getUrl(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (ConanAssetHelper.DOWNLOAD_ASSET_KINDS.contains((Object)assetKind)) {
            return context.getRequest().getPath().substring(1);
        }
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coords = ConanProxyHelper.convertFromState(state);
        if (assetKind == AssetKind.CONAN_MANIFEST) {
            return this.getUrlForConanManifest(coords);
        }
        this.log.info("AssetKind {} to be fetched is {}", (Object)assetKind, (Object)context.getRequest().getPath());
        return ((ConanContentFacet)this.facet(ConanContentFacet.class)).getAsset(coords, AssetKind.DOWNLOAD_URL).map(fluentAsset -> {
            try {
                return this.conanUrlIndexer.findUrl(fluentAsset.download().openInputStream(), assetKind.getFilename());
            }
            catch (IOException iOException) {
                return null;
            }
        }).orElse(null);
    }

    @Nullable
    protected String getUrlForConanManifest(ConanCoords coords) {
        Optional<FluentAsset> downloadUrlAsset = ((ConanContentFacet)this.facet(ConanContentFacet.class)).getAsset(coords, AssetKind.DOWNLOAD_URL);
        if (downloadUrlAsset.isPresent()) {
            try {
                return this.conanUrlIndexer.findUrl(downloadUrlAsset.get().download().openInputStream(), AssetKind.CONAN_MANIFEST.getFilename());
            }
            catch (IOException e) {
                String downloadUrlsAssetPath = ConanProxyHelper.getProxyAssetPath(coords, AssetKind.DOWNLOAD_URL);
                this.log.warn("Failed to read manifest blob of '{}': {}", new Object[]{downloadUrlsAssetPath, e.getMessage(), this.log.isDebugEnabled() ? e : null});
                return null;
            }
        }
        String digestAssetPath = ConanProxyHelper.getProxyAssetPath(coords, AssetKind.DIGEST);
        return ((ConanContentFacet)this.facet(ConanContentFacet.class)).getAsset(coords, AssetKind.DIGEST).map(digest -> {
            try {
                return this.conanUrlIndexer.findUrl(digest.download().openInputStream(), AssetKind.CONAN_MANIFEST.getFilename());
            }
            catch (IOException e) {
                this.log.warn("Failed to read digest blob of '{}': {}", new Object[]{digestAssetPath, e.getMessage(), this.log.isDebugEnabled() ? e : null});
                return null;
            }
        }).orElseThrow(() -> new IllegalStateException("DIGEST not found at " + digestAssetPath));
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return (CacheController)Preconditions.checkNotNull((Object)this.cacheControllerHolder.get(assetKind.getCacheType()));
    }
}

