/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class ConanHostedRevisionsUploadRecipeHandler
implements Handler {
    private static final String X_CHECKSUM_DEPLOY = "X-Checksum-Deploy";

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Request request = context.getRequest();
        if (request.getHeaders().contains(X_CHECKSUM_DEPLOY)) {
            return HttpResponses.notFound();
        }
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanHostedRevisionsCoords coords = ConanHostedRevisionsHelper.convertFromState(state);
        ((ConanContentFacet)context.getRepository().facet(ConanContentFacet.class)).putRevisionsRecipe(request.getPayload(), coords);
        return HttpResponses.ok();
    }
}

