/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.matchers.ActionMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.LogicMatchers;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public class ConanHostedRevisionsRoutes {
    private static final String COMMON_PATH = "/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}";
    private static final String DOWNLOAD_COMMON_PATH = "/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}";

    public static Route.Builder getLatestRecipeRevision() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/latest")}));
    }

    public static Route.Builder uploadRecipe() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"PUT"}), LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.recipeConanExportMatcher(), ConanHostedRevisionsRoutes.recipeConanSourcesMatcher(), ConanHostedRevisionsRoutes.recipeConanFileMatcher(), ConanHostedRevisionsRoutes.recipeConanManifestMatcher()})}));
    }

    public static Route.Builder getRecipeFile() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.getRecipeConanExportMatcher(), ConanHostedRevisionsRoutes.getRecipeConanSourcesMatcher(), ConanHostedRevisionsRoutes.getRecipeConanFileMatcher(), ConanHostedRevisionsRoutes.getRecipeConanManifestMatcher()})}));
    }

    public static Route.Builder getRecipeRevisions() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions")}));
    }

    public static Route.Builder getPackageRevisions() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions")}));
    }

    public static Route.Builder getRecipeFileList() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files")}));
    }

    public static Route.Builder getPackageFileList() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions/{package_revision:[^/]+}/files")}));
    }

    public static Route.Builder getLatestPackageRevision() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/latest")}));
    }

    public static Route.Builder uploadPackageFile() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"PUT"}), LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.packageConanInfoMatcher(), ConanHostedRevisionsRoutes.packageConanPackageMatcher(), ConanHostedRevisionsRoutes.packageConanManifestMatcher()})}));
    }

    public static Route.Builder getPackageFile() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.getPackageConanInfoMatcher(), ConanHostedRevisionsRoutes.getPackageConanPackageMatcher(), ConanHostedRevisionsRoutes.getPackageConanManifestMatcher()})}));
    }

    public static Route.Builder getPackageBinaries() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/search")}));
    }

    public static Route.Builder getLatestPackageBinaries() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/search")}));
    }

    public static Route.Builder removeRecipeRevision() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"DELETE"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}")}));
    }

    public static Route.Builder removePackageRevision() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"DELETE"}), new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions/{package_revision:[^/]+}")}));
    }

    private static Matcher getRecipeConanExportMatcher() {
        return LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.recipeConanExportMatcher(), new TokenMatcher("/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files/{file_path:conan_export.tgz}")});
    }

    private static Matcher recipeConanExportMatcher() {
        return new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files/{file_path:conan_export.tgz}");
    }

    private static Matcher getRecipeConanSourcesMatcher() {
        return LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.recipeConanSourcesMatcher(), new TokenMatcher("/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files/{file_path:conan_sources.tgz}")});
    }

    private static Matcher recipeConanSourcesMatcher() {
        return new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files/{file_path:conan_sources.tgz}");
    }

    private static Matcher getRecipeConanFileMatcher() {
        return LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.recipeConanFileMatcher(), new TokenMatcher("/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files/{file_path:conanfile.py}")});
    }

    private static Matcher recipeConanFileMatcher() {
        return new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files/{file_path:conanfile.py}");
    }

    private static Matcher getRecipeConanManifestMatcher() {
        return LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.recipeConanManifestMatcher(), new TokenMatcher("/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files/{file_path:conanmanifest.txt}")});
    }

    private static Matcher recipeConanManifestMatcher() {
        return new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/files/{file_path:conanmanifest.txt}");
    }

    private static Matcher getPackageConanInfoMatcher() {
        return LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.packageConanInfoMatcher(), new TokenMatcher("/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions/{package_revision:[^/]+}/files/{file_path:conaninfo.txt}")});
    }

    private static Matcher packageConanInfoMatcher() {
        return new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions/{package_revision:[^/]+}/files/{file_path:conaninfo.txt}");
    }

    private static Matcher getPackageConanManifestMatcher() {
        return LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.packageConanManifestMatcher(), new TokenMatcher("/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions/{package_revision:[^/]+}/files/{file_path:conanmanifest.txt}")});
    }

    private static Matcher packageConanManifestMatcher() {
        return new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions/{package_revision:[^/]+}/files/{file_path:conanmanifest.txt}");
    }

    private static Matcher getPackageConanPackageMatcher() {
        return LogicMatchers.or((Matcher[])new Matcher[]{ConanHostedRevisionsRoutes.packageConanPackageMatcher(), new TokenMatcher("/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions/{package_revision:[^/]+}/files/{file_path:conan_package.tgz}")});
    }

    private static Matcher packageConanPackageMatcher() {
        return new TokenMatcher("/v2/conans/{name:[^/]+}/{version:[^/]+}/{username:[^/]+}/{channel:[^/]+}/revisions/{recipe_revision:[^/]+}/packages/{package_id:[^/]+}/revisions/{package_revision:[^/]+}/files/{file_path:conan_package.tgz}");
    }
}

