/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ConanHostedRevisionsRemovePackageRevisionHandler
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanHostedRevisionsCoords coords = ConanHostedRevisionsHelper.convertFromState(state);
        List<Asset> packages = ((ConanContentFacet)context.getRepository().facet(ConanContentFacet.class)).findAssetsAsPackageRevisionFiles(coords);
        if (packages.isEmpty()) {
            return HttpResponses.notFound();
        }
        ContentMaintenanceFacet maintenanceFacet = (ContentMaintenanceFacet)context.getRepository().facet(ContentMaintenanceFacet.class);
        packages.forEach(arg_0 -> ((ContentMaintenanceFacet)maintenanceFacet).deleteAsset(arg_0));
        return HttpResponses.ok((Payload)new StringPayload("", "application/json"));
    }
}

