/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.models.FileListInfo;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.models.PackageRevisionListInfo;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.models.RecipeRevisionListInfo;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.models.RevisionInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public class ConanHostedRevisionsHelper {
    public static final String NAME = "name";
    public static final String VERSION = "version";
    public static final String USERNAME = "username";
    public static final String CHANNEL = "channel";
    public static final String RECIPE_REVISION = "recipe_revision";
    public static final String PACKAGE_ID = "package_id";
    public static final String PACKAGE_REVISION = "package_revision";
    public static final String FILE_PATH = "file_path";

    public static ConanHostedRevisionsCoords convertFromState(TokenMatcher.State state) {
        String name = (String)state.getTokens().get(NAME);
        String version = (String)state.getTokens().get(VERSION);
        String username = (String)state.getTokens().get(USERNAME);
        String channel = (String)state.getTokens().get(CHANNEL);
        String recipeRevision = (String)state.getTokens().get(RECIPE_REVISION);
        String filePath = (String)state.getTokens().get(FILE_PATH);
        String packageId = (String)state.getTokens().get(PACKAGE_ID);
        String packageRevision = (String)state.getTokens().get(PACKAGE_REVISION);
        return new ConanHostedRevisionsCoords(name, version, username, channel, recipeRevision, packageId, packageRevision, filePath);
    }

    public static RevisionInfo buildRevisionInfo(Component component) {
        RevisionInfo revisionInfo = new RevisionInfo();
        revisionInfo.setRevision((String)component.attributes("conan").get("revision", String.class));
        revisionInfo.setTime(component.created().toString());
        return revisionInfo;
    }

    public static RevisionInfo buildRevisionInfo(Asset asset) {
        RevisionInfo revisionInfo = new RevisionInfo();
        revisionInfo.setRevision((String)asset.attributes("conan").get("packageRevision", String.class));
        revisionInfo.setTime(asset.created().toString());
        return revisionInfo;
    }

    public static RecipeRevisionListInfo buildRecipeRevisionListInfo(ConanHostedRevisionsCoords coords, List<Component> components) {
        RecipeRevisionListInfo recipeRevisionListInfo = new RecipeRevisionListInfo();
        recipeRevisionListInfo.setReference(ConanHostedRevisionsHelper.buildRecipeReference(coords));
        List<RevisionInfo> revisionInfoList = components.stream().map(ConanHostedRevisionsHelper::buildRevisionInfo).collect(Collectors.toList());
        recipeRevisionListInfo.setRevisions(revisionInfoList);
        return recipeRevisionListInfo;
    }

    public static PackageRevisionListInfo buildPackageRevisionListInfo(ConanHostedRevisionsCoords coords, List<Asset> assets) {
        PackageRevisionListInfo packageRevisionListInfo = new PackageRevisionListInfo();
        packageRevisionListInfo.setPackageReference(ConanHostedRevisionsHelper.buildPackageReference(coords));
        List<RevisionInfo> revisionInfoList = assets.stream().map(ConanHostedRevisionsHelper::buildRevisionInfo).collect(Collectors.toList());
        packageRevisionListInfo.setRevisions(revisionInfoList);
        return packageRevisionListInfo;
    }

    public static FileListInfo buildFilesInfo(List<Asset> assets) {
        FileListInfo fileListInfo = new FileListInfo();
        Map<String, Object> files = assets.stream().collect(Collectors.toMap(v -> StringUtils.substringAfterLast((String)v.path(), (String)"/"), v -> Collections.EMPTY_MAP));
        fileListInfo.setFiles(files);
        return fileListInfo;
    }

    public static String getRevisionsRecipePath(ConanHostedRevisionsCoords coords) {
        return String.format("/conans/%s/%s/%s/%s/revisions/%s/files/%s", coords.getName(), coords.getVersion(), coords.getUsername(), coords.getChannel(), coords.getRecipeRevision(), coords.getFilePath());
    }

    public static String getRevisionsPackagePath(ConanHostedRevisionsCoords coords) {
        return "/" + String.join((CharSequence)"/", "conans", coords.getName(), coords.getVersion(), coords.getUsername(), coords.getChannel(), "revisions", coords.getRecipeRevision(), "packages", coords.getPackageId(), "revisions", coords.getPackageRevision(), "files", coords.getFilePath());
    }

    public static String getAllPackageRevisionsPathLike(ConanHostedRevisionsCoords coords) {
        return "/" + String.join((CharSequence)"/", "conans", coords.getName(), coords.getVersion(), coords.getUsername(), coords.getChannel(), "revisions", coords.getRecipeRevision(), "packages", coords.getPackageId(), "revisions", "%");
    }

    public static String getRecipeRevisionFileListPathLike(ConanHostedRevisionsCoords coords) {
        return "/" + String.join((CharSequence)"/", "conans", coords.getName(), coords.getVersion(), coords.getUsername(), coords.getChannel(), "revisions", coords.getRecipeRevision(), "files", "%");
    }

    public static String getPackageRevisionFileListPathLike(ConanHostedRevisionsCoords coords) {
        return "/" + String.join((CharSequence)"/", "conans", coords.getName(), coords.getVersion(), coords.getUsername(), coords.getChannel(), "revisions", coords.getRecipeRevision(), "packages", coords.getPackageId(), "revisions", coords.getPackageRevision(), "files", "%");
    }

    public static String buildComponentVersion(String version, String channel, String revision) {
        return String.format("%s-%s#%s", version, channel, revision);
    }

    public static String buildRecipeReference(ConanHostedRevisionsCoords coords) {
        return String.format("%s/%s@%s/%s", coords.getName(), coords.getVersion(), coords.getUsername(), coords.getChannel());
    }

    public static String buildPackageReference(ConanHostedRevisionsCoords coords) {
        return String.format("%s/%s@%s/%s#%s:%s", coords.getName(), coords.getVersion(), coords.getUsername(), coords.getChannel(), coords.getRecipeRevision(), coords.getPackageId());
    }

    public static Map<String, Object> getPackageFormatAttributes(ConanHostedRevisionsCoords coords) {
        Map<String, Object> attributes = ConanHostedRevisionsHelper.getRecipeFormatAttributes(coords);
        attributes.put("packageId", coords.getPackageId());
        attributes.put("packageRevision", coords.getPackageRevision());
        return attributes;
    }

    public static Map<String, Object> getRecipeFormatAttributes(ConanHostedRevisionsCoords coords) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("baseVersion", coords.getVersion());
        attributes.put(CHANNEL, coords.getChannel());
        attributes.put("revision", coords.getRecipeRevision());
        return attributes;
    }
}

