/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.models.PackageRevisionListInfo;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ConanHostedRevisionsGetPackageRevisionsHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public ConanHostedRevisionsGetPackageRevisionsHandler(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws JsonProcessingException {
        TokenMatcher.State state;
        ConanHostedRevisionsCoords coords;
        ConanContentFacet facet = (ConanContentFacet)context.getRepository().facet(ConanContentFacet.class);
        List<Asset> assets = facet.findAssetsWithPackageRevisions(coords = ConanHostedRevisionsHelper.convertFromState(state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class)));
        if (assets.isEmpty()) {
            return HttpResponses.notFound();
        }
        PackageRevisionListInfo revisions = ConanHostedRevisionsHelper.buildPackageRevisionListInfo(coords, assets);
        String json = this.objectMapper.writeValueAsString((Object)revisions);
        return HttpResponses.ok((Payload)new StringPayload(json, "application/json"));
    }
}

