/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.models.FileListInfo;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ConanHostedRevisionsGetPackageFileListHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public ConanHostedRevisionsGetPackageFileListHandler(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanHostedRevisionsCoords coords = ConanHostedRevisionsHelper.convertFromState(state);
        List<Asset> assets = ((ConanContentFacet)context.getRepository().facet(ConanContentFacet.class)).findAssetsAsPackageRevisionFiles(coords);
        if (assets.isEmpty()) {
            return HttpResponses.notFound();
        }
        FileListInfo recipeFiles = ConanHostedRevisionsHelper.buildFilesInfo(assets);
        String json = this.objectMapper.writeValueAsString((Object)recipeFiles);
        return HttpResponses.ok((Payload)new StringPayload(json, "application/json"));
    }
}

