/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsBinariesHelper;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ConanHostedRevisionsGetPackageBinariesHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public ConanHostedRevisionsGetPackageBinariesHandler(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanHostedRevisionsCoords coords = ConanHostedRevisionsHelper.convertFromState(state);
        Optional<List<Asset>> conanInfos = ((ConanContentFacet)context.getRepository().facet(ConanContentFacet.class)).getConanInfos(coords);
        if (!conanInfos.isPresent()) {
            return HttpResponses.notFound();
        }
        Map<String, Object> binaries = ConanHostedRevisionsBinariesHelper.buildBinaries((Iterable<Asset>)conanInfos.get());
        StringPayload payload = new StringPayload(this.objectMapper.writeValueAsString(binaries), "application/json");
        return HttpResponses.ok((Payload)payload);
    }
}

