/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.models.RevisionInfo;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ConanHostedRevisionsGetLatestRecipeRevisionHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public ConanHostedRevisionsGetLatestRecipeRevisionHandler(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws JsonProcessingException {
        TokenMatcher.State state;
        ConanHostedRevisionsCoords coords;
        ConanContentFacet facet = (ConanContentFacet)context.getRepository().facet(ConanContentFacet.class);
        Optional<Component> component = facet.findComponentWithLatestRecipeRevision(coords = ConanHostedRevisionsHelper.convertFromState(state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class)));
        if (!component.isPresent()) {
            return HttpResponses.notFound();
        }
        RevisionInfo revisionInfo = ConanHostedRevisionsHelper.buildRevisionInfo(component.get());
        StringPayload payload = new StringPayload(this.objectMapper.writeValueAsString((Object)revisionInfo), "application/json");
        return HttpResponses.ok((Payload)payload);
    }
}

