/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.models.RevisionInfo;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ConanHostedRevisionsGetLatestPackageRevisionHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public ConanHostedRevisionsGetLatestPackageRevisionHandler(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws JsonProcessingException {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanHostedRevisionsCoords coords = ConanHostedRevisionsHelper.convertFromState(state);
        Optional<Asset> latestPackageRevision = ((ConanContentFacet)context.getRepository().facet(ConanContentFacet.class)).findAssetWithLatestPackageRevision(coords);
        if (!latestPackageRevision.isPresent()) {
            return HttpResponses.notFound();
        }
        RevisionInfo revisionInfo = ConanHostedRevisionsHelper.buildRevisionInfo(latestPackageRevision.get());
        StringPayload payload = new StringPayload(this.objectMapper.writeValueAsString((Object)revisionInfo), "application/json");
        return HttpResponses.ok((Payload)payload);
    }
}

