/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted.revisions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.content.Asset;

public class ConanHostedRevisionsBinariesHelper {
    public static final String CONAN_INFO_BINARY = "infoBinary";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> MAP_STRING_OBJECT = new TypeReference<Map<String, Object>>(){};
    private static final String SETTINGS = "settings";
    private static final String OPTIONS = "options";
    private static final String REQUIRES = "requires";
    private static final String FULL_REQUIRES = "full_requires";
    private static final String RECIPE_HASH = "recipe_hash";

    public static Map<String, Object> buildBinaries(Iterable<Asset> conanInfoAssets) {
        HashMap<String, Object> binaries = new HashMap<String, Object>();
        for (Asset conanInfoAsset : conanInfoAssets) {
            Map formatAttributes = conanInfoAsset.attributes("conan").backing();
            Map<String, Object> binary = ConanHostedRevisionsBinariesHelper.buildBinary(formatAttributes);
            if (binary.isEmpty()) continue;
            String packageId = (String)formatAttributes.get("packageId");
            binaries.put(packageId, binary);
        }
        return binaries;
    }

    private static Map<String, Object> buildBinary(Map<String, Object> formatAttributes) {
        String json = (String)formatAttributes.get(CONAN_INFO_BINARY);
        if (json == null) {
            return Collections.emptyMap();
        }
        return ConanHostedRevisionsBinariesHelper.deserialize(json, MAP_STRING_OBJECT);
    }

    public static String getConanInfoAttributesAsJson(InputStreamSupplier conanInputStreamSupplier) {
        return ConanHostedRevisionsBinariesHelper.serialize(ConanHostedRevisionsBinariesHelper.getConanInfoAttributes(conanInputStreamSupplier));
    }

    private static Map<String, Object> getConanInfoAttributes(InputStreamSupplier conanInfoContentSupplier) {
        Pattern tagPattern = Pattern.compile("\\[[^\\]]+?\\][^\\[]*", 32);
        String conanInfo = ConanHostedRevisionsBinariesHelper.deserializeConanInfo(conanInfoContentSupplier);
        Matcher tagMatcher = tagPattern.matcher(conanInfo);
        HashMap<String, Object> values = new HashMap<String, Object>();
        while (tagMatcher.find()) {
            String[] section = tagMatcher.group().split("[\n\r]+");
            if (section.length < 2) continue;
            String header = section[0].replaceAll("[\\[\\]]", "");
            String[] fields = Arrays.copyOfRange(section, 1, section.length);
            switch (header) {
                case "options": 
                case "settings": {
                    ConanHostedRevisionsBinariesHelper.putObject(values, header, fields);
                    break;
                }
                case "requires": {
                    ConanHostedRevisionsBinariesHelper.putArray(values, header, fields);
                    break;
                }
                case "recipe_hash": {
                    ConanHostedRevisionsBinariesHelper.putField(values, header, fields);
                    break;
                }
                case "full_requires": {
                    ConanHostedRevisionsBinariesHelper.putArray(values, REQUIRES, fields);
                }
            }
        }
        return values;
    }

    private static String deserializeConanInfo(InputStreamSupplier supplier) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = supplier.get();){
                return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void putObject(Map<String, Object> node, String fieldName, String[] values) {
        HashMap sectionNode = new HashMap();
        Arrays.stream(values).forEach(field -> {
            String[] fieldPair = field.split("=", 2);
            if (fieldPair.length == 2) {
                String key = StringUtils.trim((String)fieldPair[0]);
                String value = StringUtils.trim((String)fieldPair[1]);
                sectionNode.put(key, value);
            }
        });
        node.put(fieldName, sectionNode);
    }

    private static void putArray(Map<String, Object> node, String fieldName, String[] values) {
        List list = Arrays.stream(values).map(StringUtils::trim).collect(Collectors.toList());
        node.put(fieldName, list);
    }

    private static void putField(Map<String, Object> node, String fieldName, String[] values) {
        String value = StringUtils.trim((String)values[0]);
        node.put(fieldName, value);
    }

    private static <T> T deserialize(String json, TypeReference<T> type) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String serialize(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

