/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.internal.hosted.ConanHostedFacet;
import com.sonatype.repository.conan.internal.hosted.ConanHostedHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named(value="conan")
public class ConanHostedFacetImpl
extends FacetSupport
implements ConanHostedFacet {
    @Override
    public Response get(Context context) {
        this.log.debug("Request {}", (Object)context.getRequest().getPath());
        ConanCoords coords = ConanHostedHelper.convertFromState((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class));
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return ((ConanContentFacet)this.getRepository().facet(ConanContentFacet.class)).getAsset(coords, assetKind).map(FluentAsset::download).map(HttpResponses::ok).orElseGet(HttpResponses::notFound);
    }

    @Override
    public Response upload(ConanCoords coords, Payload payload, AssetKind assetKind) throws IOException {
        Preconditions.checkNotNull((Object)coords);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)((Object)assetKind));
        if (payload.getSize() > 0L) {
            ((ConanContentFacet)this.facet(ConanContentFacet.class)).putPackage(payload, coords, assetKind).download();
        } else {
            this.log.debug("Skipping upload with empty payload: {}, {}", (Object)coords, (Object)assetKind);
        }
        return HttpResponses.ok();
    }

    @Override
    public String getUploadUrlAsJson(ConanCoords coords, Set<String> assetsToUpload) throws JsonProcessingException {
        return ConanHostedHelper.getUploadUrlAsJson(coords, assetsToUpload, this.getRepository());
    }

    @Override
    public String getDownloadUrlAsJson(ConanCoords coords) throws JsonProcessingException {
        if (StringUtils.isEmpty((CharSequence)coords.getSha())) {
            Map<String, String> downloadUrls = this.generateDownloadUrls(DOWNLOAD_URL_ASSET_KINDS, coords, this.getRepository());
            if (downloadUrls.isEmpty()) {
                return null;
            }
            return ConanHostedHelper.MAPPER.writeValueAsString(downloadUrls);
        }
        return this.generateDownloadPackagesUrlsAsJson(coords, this.getRepository());
    }

    @Override
    public String getDigestAsJson(ConanCoords coords) throws JsonProcessingException {
        String repositoryUrl = this.getRepository().getUrl();
        return this.generateDigestAsJson(coords, repositoryUrl);
    }

    @Override
    public String generatePackageSnapshotAsJson(ConanCoords coords) throws JsonProcessingException {
        Map<String, String> downloadUrls = DOWNLOAD_URL_PACKAGE_ASSET_KINDS.stream().collect(Collectors.toMap(AssetKind::getFilename, assetKind -> ConanHostedHelper.getHostedAssetPath(coords, assetKind)));
        Map<String, String> packageSnapshot = downloadUrls.entrySet().stream().flatMap(entry -> {
            String value = (String)entry.getValue();
            String hash = this.getHash(value);
            if (hash != null) {
                return Stream.of(Pair.of((Object)((String)entry.getKey()), (Object)hash));
            }
            return Stream.empty();
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        if (packageSnapshot.isEmpty()) {
            return null;
        }
        return ConanHostedHelper.MAPPER.writeValueAsString(packageSnapshot);
    }

    @Nullable
    private String generateDownloadPackagesUrlsAsJson(ConanCoords coords, Repository repository) throws JsonProcessingException {
        Map<String, String> downloadUrls = this.generateDownloadUrls(DOWNLOAD_URL_PACKAGE_ASSET_KINDS, coords, repository);
        if (downloadUrls.isEmpty()) {
            return null;
        }
        return ConanHostedHelper.MAPPER.writeValueAsString(downloadUrls);
    }

    @Nullable
    @TransactionalTouchBlob
    public String getHash(String path) {
        Preconditions.checkNotNull((Object)path);
        Optional assetOptional = ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().path(this.getPrefixedPath(path)).find();
        if (!assetOptional.isPresent()) {
            return null;
        }
        Optional blobOptional = ((FluentAsset)assetOptional.get()).blob();
        if (!blobOptional.isPresent()) {
            this.log.error("Cannot get hash for blob, blob is missing for asset with path: {}", (Object)this.getPrefixedPath(path));
            throw new MissingBlobException(null);
        }
        return (String)((AssetBlob)blobOptional.get()).checksums().get(HashAlgorithm.MD5.name());
    }

    private Map<String, String> generateDownloadUrls(List<AssetKind> assetKinds, ConanCoords coords, Repository repository) {
        return assetKinds.stream().filter(assetKind -> ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().path(this.getPrefixedPath(ConanHostedHelper.getHostedAssetPath(coords, assetKind))).find().isPresent()).collect(Collectors.toMap(AssetKind::getFilename, x -> String.valueOf(repository.getUrl()) + this.getPrefixedPath(ConanHostedHelper.getHostedAssetPath(coords, x))));
    }

    private String generateDigestAsJson(ConanCoords coords, String repositoryUrl) throws JsonProcessingException {
        HashMap<String, String> digest = new HashMap<String, String>();
        digest.put(AssetKind.CONAN_MANIFEST.getFilename(), String.valueOf(repositoryUrl) + this.getPrefixedPath(ConanHostedHelper.getHostedAssetPath(coords, AssetKind.CONAN_MANIFEST)));
        return ConanHostedHelper.MAPPER.writeValueAsString(digest);
    }

    private String getPrefixedPath(String path) {
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }
}

