/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted;

import com.google.common.base.Preconditions;
import com.sonatype.repository.conan.internal.common.PingController;
import com.sonatype.repository.conan.internal.datastore.UserController;
import com.sonatype.repository.conan.internal.datastore.hosted.ConanHostedControllerV1;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsController;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Router;

@Named
@Singleton
public class ConanHostedAPI
extends ComponentSupport {
    private static final String VERSION_V1 = "v1";
    private static final String VERSION_V2 = "v2";
    private final PingController pingController;
    private final UserController userController;
    private final ConanHostedControllerV1 conanHostedControllerV1;
    private final ConanHostedRevisionsController conanHostedRevisionsController;

    @Inject
    public ConanHostedAPI(PingController pingController, UserController userController, ConanHostedControllerV1 conanHostedControllerV1, ConanHostedRevisionsController conanHostedRevisionsController) {
        this.pingController = (PingController)((Object)Preconditions.checkNotNull((Object)((Object)pingController)));
        this.userController = (UserController)((Object)Preconditions.checkNotNull((Object)((Object)userController)));
        this.conanHostedControllerV1 = (ConanHostedControllerV1)((Object)Preconditions.checkNotNull((Object)((Object)conanHostedControllerV1)));
        this.conanHostedRevisionsController = (ConanHostedRevisionsController)Preconditions.checkNotNull((Object)conanHostedRevisionsController);
    }

    public void create(Router.Builder builder) {
        this.pingController.attach(builder, VERSION_V1, true);
        this.conanHostedRevisionsController.attach(builder);
        this.userController.attach(builder, VERSION_V2);
        this.userController.attach(builder, VERSION_V1);
        this.conanHostedControllerV1.attach(builder);
    }
}

