/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.browse;

import com.google.common.base.Preconditions;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.internal.common.ConanBrowseNodeGeneratorHelper;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.browse.node.BrowsePathBuilder;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.browse.ComponentPathBrowseNodeGenerator;

@Singleton
@Named(value="conan")
public class ConanBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<BrowsePath> computeComponentPaths(Asset asset) {
        ArrayList componentList = new ArrayList();
        asset.component().ifPresent(component -> {
            componentList.add(component.namespace());
            componentList.add(component.name());
            componentList.add(component.version());
        });
        return BrowsePathBuilder.fromPaths(componentList, (boolean)true);
    }

    public List<BrowsePath> computeAssetPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        if (asset.component().isPresent()) {
            boolean isPackageSnapshot = AssetKind.CONAN_PACKAGE_SNAPSHOT.name().equals(asset.kind());
            return ConanBrowseNodeGenerator.addAllAssetPaths(this.computeComponentPaths(asset), BrowsePathBuilder.fromPaths(ConanBrowseNodeGeneratorHelper.assetSegment(asset.path()), (boolean)isPackageSnapshot));
        }
        return super.computeAssetPaths(asset);
    }

    private static List<BrowsePath> addAllAssetPaths(List<BrowsePath> componentPaths, List<BrowsePath> assetPaths) {
        String parentPath = componentPaths.isEmpty() ? "" : componentPaths.get(componentPaths.size() - 1).getRequestPath();
        for (BrowsePath path : assetPaths) {
            path.setRequestPath(String.valueOf(StringUtils.removeEnd((String)parentPath, (String)"/")) + path.getRequestPath());
        }
        componentPaths.addAll(assetPaths);
        return componentPaths;
    }
}

