/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.internal.metadata.ConanManifest;
import java.io.IOException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;

public class ConanHashVerifier
extends ComponentSupport {
    public HashCode lookupHashFromAsset(Repository repository, String assetPath) {
        String filename;
        Preconditions.checkNotNull((Object)assetPath);
        AttributesMap attributes = this.getConanmanifestHashes(repository, assetPath);
        if (attributes != null && attributes.contains(filename = ConanHashVerifier.getFilenameFromPath(assetPath))) {
            return HashCode.fromString((String)((String)attributes.get(filename)));
        }
        return null;
    }

    private AttributesMap getConanmanifestHashes(Repository repository, String assetPath) {
        String originalFilename = ConanHashVerifier.getFilenameFromPath(assetPath);
        String manifestFile = assetPath.replace(originalFilename, AssetKind.CONAN_MANIFEST.getFilename());
        return ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(manifestFile).find().map(fluentAsset -> {
            try {
                return ConanManifest.parse(fluentAsset.download().openInputStream());
            }
            catch (IOException | MissingBlobException e) {
                this.log.warn("Failed to open manifest blob: {} asset: {} repository: {}", new Object[]{e.getMessage(), fluentAsset.path(), repository.getName(), this.log.isDebugEnabled() ? e : null});
                return null;
            }
        }).orElse(null);
    }

    private static String getFilenameFromPath(String assetPath) {
        String[] split = assetPath.split("/");
        return split[split.length - 1];
    }

    public boolean verify(HashCode me, HashCode you) {
        return me == null || you == null || me.equals((Object)you);
    }
}

