/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.conan.datastore.ConanContentFacet;
import com.sonatype.nexus.repository.conan.datastore.store.ConanAssetStore;
import com.sonatype.nexus.repository.conan.datastore.store.ConanComponentStore;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.ConanWritePolicySelector;
import com.sonatype.repository.conan.internal.datastore.ConanHashVerifier;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsBinariesHelper;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import com.sonatype.repository.conan.internal.datastore.proxy.ConanProxyHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="conan")
public class ConanContentFacetImpl
extends ContentFacetSupport
implements ConanContentFacet {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA512, (Object)HashAlgorithm.MD5);
    private final ConanHashVerifier hashVerifier;

    @Inject
    protected ConanContentFacetImpl(@Named(value="conan") @Named(value="conan") FormatStoreManager formatStoreManager, ConanHashVerifier hashVerifier) {
        super(formatStoreManager);
        this.hashVerifier = hashVerifier;
    }

    @Override
    public Optional<FluentAsset> getAsset(ConanCoords coords, AssetKind assetKind) {
        return ((ContentFacet)this.facet(ContentFacet.class)).assets().path(ConanProxyHelper.getProxyAssetPath(coords, assetKind)).find();
    }

    @Override
    public Optional<FluentAsset> getRevisionsRecipeAsset(ConanHostedRevisionsCoords coords) {
        String assetPath = ConanHostedRevisionsHelper.getRevisionsRecipePath(coords);
        return this.assets().path(assetPath).find();
    }

    protected WritePolicy writePolicy(Asset asset) {
        return ConanWritePolicySelector.select(asset, super.writePolicy(asset));
    }

    @Override
    public FluentAsset putPackage(Payload payload, ConanCoords coords, AssetKind assetKind) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return this.assets().path(ConanProxyHelper.getProxyAssetPath(coords, assetKind)).component((Component)this.getOrCreateComponent(coords)).kind(assetKind.name()).blob(tempBlob).save().markAsCached(payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public FluentAsset putRevisionsRecipe(Payload payload, ConanHostedRevisionsCoords coords) {
        FluentComponent component = this.getOrCreateRevisionsComponent(coords);
        AssetKind assetKind = AssetKind.valueFromFileName(coords.getFilePath());
        String path = ConanHostedRevisionsHelper.getRevisionsRecipePath(coords);
        Map<String, Object> formatAttributes = ConanHostedRevisionsHelper.getRecipeFormatAttributes(coords);
        Throwable throwable = null;
        Object var8_9 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return this.assets().path(path).component((Component)component).blob(tempBlob).kind(assetKind.name()).attributes("conan", formatAttributes).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public FluentAsset putRevisionsPackage(Payload payload, ConanHostedRevisionsCoords coords) {
        FluentComponent component = this.getOrCreateRevisionsComponent(coords);
        AssetKind assetKind = AssetKind.valueFromFileName(coords.getFilePath());
        String assetPath = ConanHostedRevisionsHelper.getRevisionsPackagePath(coords);
        Map<String, Object> formatAttributes = ConanHostedRevisionsHelper.getPackageFormatAttributes(coords);
        Throwable throwable = null;
        Object var8_9 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            if (assetKind == AssetKind.CONAN_INFO) {
                String conanInfoAsJson = ConanHostedRevisionsBinariesHelper.getConanInfoAttributesAsJson((InputStreamSupplier)tempBlob);
                formatAttributes.put("infoBinary", conanInfoAsJson);
            }
            return this.assets().path(assetPath).component((Component)component).blob(tempBlob).kind(assetKind.name()).attributes("conan", formatAttributes).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Optional<FluentAsset> getRevisionsPackageAsset(ConanHostedRevisionsCoords coords) {
        String assetPath = ConanHostedRevisionsHelper.getRevisionsPackagePath(coords);
        return this.assets().path(assetPath).find();
    }

    @Override
    public Optional<FluentAsset> putMetadata(Payload payload, ConanCoords coords, AssetKind assetKind) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            String assetPath = ConanProxyHelper.getProxyAssetPath(coords, assetKind);
            HashCode hashFromManifest = this.hashVerifier.lookupHashFromAsset(this.getRepository(), assetPath);
            HashCode newAssetHash = (HashCode)tempBlob.getHashes().get(HashAlgorithm.MD5);
            if (!this.hashVerifier.verify(hashFromManifest, newAssetHash)) {
                return Optional.empty();
            }
            return Optional.of(this.assets().path(assetPath).component((Component)this.getOrCreateComponent(coords)).kind(assetKind.name()).blob(tempBlob).save().markAsCached(payload));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Stream<FluentAsset> listExistingBinaries(ConanCoords conanCoords) {
        return this.getComponent(conanCoords).map(this::getPackageManifests).orElse(Stream.empty());
    }

    @Override
    public List<Asset> getConanInfoAssets(Component component) {
        ConanAssetStore assetStore = (ConanAssetStore)this.stores().assetStore;
        return assetStore.findAssetsByComponentAndKind(this.getRepository(), component, AssetKind.CONAN_INFO.name());
    }

    @Override
    public Optional<List<Asset>> getConanInfos(ConanHostedRevisionsCoords coords) {
        List<Component> components = this.findComponentsWithRecipeRevisions(coords);
        if (components.isEmpty()) {
            return Optional.empty();
        }
        Optional<Component> component = components.stream().filter(comp -> Objects.equals(comp.attributes("conan").get("revision"), coords.getRecipeRevision())).findFirst();
        if (!component.isPresent()) {
            return Optional.of(Collections.emptyList());
        }
        ConanAssetStore assetStore = (ConanAssetStore)this.stores().assetStore;
        return Optional.of(assetStore.findAssetsByComponentAndKind(this.getRepository(), component.get(), AssetKind.CONAN_INFO.name()));
    }

    @Override
    public Optional<Component> findComponentWithLatestRecipeRevision(ConanHostedRevisionsCoords coords) {
        ConanComponentStore conanComponentStore = (ConanComponentStore)this.stores().componentStore;
        Repository repository = this.getRepository();
        return Optional.ofNullable(conanComponentStore.findComponentWithLatestRecipeRevision(repository, coords));
    }

    @Override
    public List<Component> findComponentsWithRecipeRevisions(ConanHostedRevisionsCoords coords) {
        ConanComponentStore conanComponentStore = (ConanComponentStore)this.stores().componentStore;
        Repository repository = this.getRepository();
        return conanComponentStore.findComponentsWithRecipeRevisions(repository, coords);
    }

    @Override
    public List<Asset> findAssetsWithPackageRevisions(ConanHostedRevisionsCoords coords) {
        Optional<FluentComponent> component = this.getComponent(coords);
        if (!component.isPresent()) {
            return Collections.emptyList();
        }
        ConanAssetStore conanAssetStore = (ConanAssetStore)this.stores().assetStore;
        Repository repository = this.getRepository();
        List<Asset> assets = conanAssetStore.findPackageRevisions(repository, (Component)component.get(), coords);
        Map<String, List<Asset>> groupBy = assets.stream().collect(Collectors.groupingBy(asset -> (String)asset.attributes("conan").get("packageRevision", String.class)));
        return groupBy.values().stream().map(list -> list.stream().min(Comparator.comparing(RepositoryContent::created))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public List<Asset> findAssetsAsRecipeRevisionFiles(ConanHostedRevisionsCoords coords) {
        Optional<FluentComponent> component = this.getComponent(coords);
        if (!component.isPresent()) {
            return Collections.emptyList();
        }
        ConanAssetStore conanAssetStore = (ConanAssetStore)this.stores().assetStore;
        Repository repository = this.getRepository();
        return conanAssetStore.findRecipeRevisionFiles(repository, (Component)component.get(), coords);
    }

    @Override
    public List<Asset> findAssetsAsPackageRevisionFiles(ConanHostedRevisionsCoords coords) {
        Optional<FluentComponent> component = this.getComponent(coords);
        if (!component.isPresent()) {
            return Collections.emptyList();
        }
        ConanAssetStore conanAssetStore = (ConanAssetStore)this.stores().assetStore;
        Repository repository = this.getRepository();
        return conanAssetStore.findPackageRevisionFiles(repository, (Component)component.get(), coords);
    }

    @Override
    public Optional<Asset> findAssetWithLatestPackageRevision(ConanHostedRevisionsCoords coords) {
        return this.findAssetsWithPackageRevisions(coords).stream().max(Comparator.comparing(RepositoryContent::created));
    }

    private Stream<FluentAsset> getPackageManifests(FluentComponent component) {
        return component.assets().stream().filter(ConanContentFacetImpl::isConanInfoAsset);
    }

    private static boolean isConanInfoAsset(FluentAsset fluentAsset) {
        return fluentAsset.path().contains("packages") && fluentAsset.path().endsWith("/" + AssetKind.CONAN_INFO.getFilename());
    }

    private Optional<FluentComponent> getComponent(ConanCoords coords) {
        return this.populateBuilder(coords).find();
    }

    @Override
    public Optional<FluentComponent> getComponent(ConanHostedRevisionsCoords coords) {
        return this.populateBuilder(coords).find();
    }

    private FluentComponentBuilder populateBuilder(ConanCoords coords) {
        return ((ContentFacet)this.facet(ContentFacet.class)).components().name(coords.getProject()).namespace(coords.getGroup()).version(ConanProxyHelper.getComponentVersion(coords)).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(ConanProxyHelper.getComponentVersion(coords), this.repository().getFormat()));
    }

    private FluentComponentBuilder populateBuilder(ConanHostedRevisionsCoords coords) {
        return ((ContentFacet)this.facet(ContentFacet.class)).components().name(coords.getName()).namespace(coords.getUsername()).version(ConanHostedRevisionsHelper.buildComponentVersion(coords.getVersion(), coords.getChannel(), coords.getRecipeRevision())).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(ConanHostedRevisionsHelper.buildComponentVersion(coords.getVersion(), coords.getChannel(), coords.getRecipeRevision()), this.repository().getFormat()));
    }

    private FluentComponent getOrCreateComponent(ConanCoords coords) {
        FluentComponent component = this.populateBuilder(coords).getOrCreate();
        if (this.isNewRepositoryContent((RepositoryContent)component)) {
            this.setConanFormatAttributes(component, coords);
        }
        return component;
    }

    private FluentComponent getOrCreateRevisionsComponent(ConanHostedRevisionsCoords coords) {
        Map<String, Object> coordinatesFormatAttributes = ConanHostedRevisionsHelper.getRecipeFormatAttributes(coords);
        String version = ConanHostedRevisionsHelper.buildComponentVersion(coords.getVersion(), coords.getChannel(), coords.getRecipeRevision());
        return this.components().name(coords.getName()).namespace(coords.getUsername()).version(version).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(version, this.repository().getFormat())).attributes("conan", coordinatesFormatAttributes).getOrCreate();
    }

    private void setConanFormatAttributes(FluentComponent component, ConanCoords coordinates) {
        HashMap<String, String> conanAttributes = new HashMap<String, String>();
        conanAttributes.put("baseVersion", coordinates.getVersion());
        conanAttributes.put("channel", coordinates.getChannel());
        component.attributes(AttributeOperation.OVERLAY, "conan", conanAttributes);
    }

    private boolean isNewRepositoryContent(RepositoryContent repositoryContent) {
        return repositoryContent.attributes().isEmpty();
    }
}

