/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.common;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.ActionMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.LogicMatchers;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class PingController
extends ComponentSupport {
    private static final String PING = "/%s/ping";
    private static final String CONAN_SERVER_CAPABILITIES = "X-Conan-Server-Capabilities";
    private static final String CONAN_SERVER_CAPABILITIES_VALUE = "revisions";
    @Inject
    TimingHandler timingHandler;
    @Inject
    SecurityHandler securityHandler;
    @Inject
    ExceptionHandler exceptionHandler;
    @Inject
    HandlerContributor handlerContributor;
    public final Handler pingHandler = context -> {
        this.log.debug("pong");
        return HttpResponses.ok();
    };
    public final Handler pingHandlerWithRevision = context -> {
        this.log.debug("pong");
        return new Response.Builder().status(Status.success((int)200)).header(CONAN_SERVER_CAPABILITIES, new String[]{CONAN_SERVER_CAPABILITIES_VALUE}).build();
    };

    private static Route.Builder ping(String version) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher(String.format(PING, version))}));
    }

    public void attach(Router.Builder builder, String version) {
        this.attach(builder, version, false);
    }

    public void attach(Router.Builder builder, String version, boolean isRevisionsEnabled) {
        Route.Builder routeBuilder = PingController.ping(version).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor);
        if (isRevisionsEnabled) {
            routeBuilder.handler(this.pingHandlerWithRevision);
        } else {
            routeBuilder.handler(this.pingHandler);
        }
        builder.route(routeBuilder.create());
    }
}

