/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal;

import com.google.common.collect.ImmutableList;
import com.sonatype.repository.conan.AssetKind;
import java.util.List;
import org.sonatype.nexus.common.hash.HashAlgorithm;

public class ConanFacetUtils {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256);
    public static final String PACKAGE_SNAPSHOT_IDENTIFIER = "packages";

    private ConanFacetUtils() {
    }

    public static boolean isPackageSnapshot(String path) {
        String[] args = path.split("/");
        if (args.length > 2) {
            String expectPackage = args[args.length - 2];
            return PACKAGE_SNAPSHOT_IDENTIFIER.equals(expectPackage);
        }
        return false;
    }

    public static boolean isPackagePath(String path) {
        return path.contains("/packages/");
    }

    public static boolean isDigest(String path) {
        return path.endsWith(AssetKind.DIGEST.getFilename());
    }
}

