/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan;

import com.google.common.base.Preconditions;
import java.util.Optional;

public class ConanReference {
    private final String name;
    private final String baseVersion;
    private final String user;
    private final String channel;

    private ConanReference(String name, String baseVersion, String user, String channel) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.baseVersion = baseVersion;
        this.user = user;
        this.channel = channel;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getBaseVersion() {
        return Optional.ofNullable(this.baseVersion);
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    public Optional<String> getChannel() {
        return Optional.ofNullable(this.channel);
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ ConanReference(String string, String string2, String string3, String string4, ConanReference conanReference) {
        this(string, string2, string3, string4);
    }

    public static class Builder {
        private String name;
        private String version;
        private String user;
        private String channel;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public ConanReference build() {
            return new ConanReference(this.name, this.version, this.user, this.channel, null);
        }
    }
}

