/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.conan.datastore.store;

import com.google.inject.assistedinject.Assisted;
import com.sonatype.nexus.repository.conan.datastore.store.ConanComponentDAO;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.transaction.Transactional;

public class ConanComponentStore
extends ComponentStore<ConanComponentDAO> {
    @Inject
    public ConanComponentStore(DataSessionSupplier sessionSupplier, @Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean clustered, @Assisted String contentStoreName) {
        super(sessionSupplier, clustered, contentStoreName, ConanComponentDAO.class);
    }

    @Nullable
    @Transactional
    public Component findComponentWithLatestRecipeRevision(Repository repository, ConanHostedRevisionsCoords coords) {
        Integer repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        String name = coords.getName();
        String versionLike = ConanHostedRevisionsHelper.buildComponentVersion(coords.getVersion(), coords.getChannel(), "%");
        String namespace = coords.getUsername();
        return ((ConanComponentDAO)this.dao()).findLatestComponentByVersionLike(repositoryId, name, versionLike, namespace);
    }

    @Transactional
    public List<Component> findComponentsWithRecipeRevisions(Repository repository, ConanHostedRevisionsCoords coords) {
        Integer repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        String name = coords.getName();
        String versionLike = ConanHostedRevisionsHelper.buildComponentVersion(coords.getVersion(), coords.getChannel(), "%");
        String namespace = coords.getUsername();
        return ((ConanComponentDAO)this.dao()).findComponentsByVersionLike(repositoryId, name, versionLike, namespace);
    }
}

