/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.conan.datastore.store;

import com.google.inject.assistedinject.Assisted;
import com.sonatype.nexus.repository.conan.datastore.store.ConanAssetDAO;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsCoords;
import com.sonatype.repository.conan.internal.datastore.hosted.revisions.ConanHostedRevisionsHelper;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.transaction.Transactional;

public class ConanAssetStore
extends AssetStore<ConanAssetDAO> {
    @Inject
    public ConanAssetStore(DataSessionSupplier sessionSupplier, @Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean clustered, @Assisted String contentStoreName) {
        super(sessionSupplier, clustered, contentStoreName, ConanAssetDAO.class);
    }

    @Transactional
    public List<Asset> findPackageRevisions(Repository repository, Component component, ConanHostedRevisionsCoords coords) {
        int repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        int componentId = InternalIds.internalComponentId((Component)component);
        String pathLike = ConanHostedRevisionsHelper.getAllPackageRevisionsPathLike(coords);
        return ((ConanAssetDAO)this.dao()).findAssetsByPathLike(repositoryId, componentId, pathLike);
    }

    @Transactional
    public List<Asset> findAssetsByComponentAndKind(Repository repository, Component component, String kind) {
        int repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        int componentId = InternalIds.internalComponentId((Component)component);
        return ((ConanAssetDAO)this.dao()).findAssetsByComponentIdAndKind(repositoryId, componentId, kind);
    }

    @Transactional
    public List<Asset> findRecipeRevisionFiles(Repository repository, Component component, ConanHostedRevisionsCoords coords) {
        int repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        int componentId = InternalIds.internalComponentId((Component)component);
        String pathLike = ConanHostedRevisionsHelper.getRecipeRevisionFileListPathLike(coords);
        return ((ConanAssetDAO)this.dao()).findAssetsByPathLike(repositoryId, componentId, pathLike);
    }

    @Transactional
    public List<Asset> findPackageRevisionFiles(Repository repository, Component component, ConanHostedRevisionsCoords coords) {
        int repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        int componentId = InternalIds.internalComponentId((Component)component);
        String pathLike = ConanHostedRevisionsHelper.getPackageRevisionFileListPathLike(coords);
        return ((ConanAssetDAO)this.dao()).findAssetsByPathLike(repositoryId, componentId, pathLike);
    }
}

