/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.webhooks;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.InitiatorProvider;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.webhooks.GlobalWebhook;
import org.sonatype.nexus.webhooks.WebhookPayload;
import org.sonatype.nexus.webhooks.WebhookSubscription;

@Named
@Singleton
public class GlobalRepositoryWebhook
extends GlobalWebhook {
    public static final String NAME = "repository";
    private final NodeAccess nodeAccess;
    private final InitiatorProvider initiatorProvider;

    @Inject
    public GlobalRepositoryWebhook(NodeAccess nodeAccess, InitiatorProvider initiatorProvider) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.initiatorProvider = (InitiatorProvider)Preconditions.checkNotNull((Object)initiatorProvider);
    }

    public String getName() {
        return NAME;
    }

    @Subscribe
    @AllowConcurrentEvents
    void on(RepositoryCreatedEvent event) {
        this.queue(event.getRepository(), EventAction.CREATED);
    }

    @Subscribe
    @AllowConcurrentEvents
    void on(RepositoryUpdatedEvent event) {
        this.queue(event.getRepository(), EventAction.UPDATED);
    }

    @Subscribe
    @AllowConcurrentEvents
    void on(RepositoryDeletedEvent event) {
        this.queue(event.getRepository(), EventAction.DELETED);
    }

    private void queue(Repository repository, EventAction eventAction) {
        RepositoryWebhookPayload.RepositoryPayload repositoryPayload = new RepositoryWebhookPayload.RepositoryPayload(repository.getName(), repository.getType(), repository.getFormat());
        RepositoryWebhookPayload payload = new RepositoryWebhookPayload(eventAction, repositoryPayload, this.nodeAccess.getId(), new Date(), this.initiatorProvider.get());
        this.getSubscriptions().forEach(subscription -> this.queue((WebhookSubscription)subscription, payload));
    }

    public static enum EventAction {
        CREATED,
        UPDATED,
        DELETED;

    }

    public static class RepositoryWebhookPayload
    extends WebhookPayload {
        private final EventAction action;
        private final RepositoryPayload repository;

        public RepositoryWebhookPayload(EventAction action, RepositoryPayload repository, String nodeId, Date timestamp, String initiator) {
            this.action = (EventAction)((Object)Preconditions.checkNotNull((Object)((Object)action)));
            this.repository = (RepositoryPayload)Preconditions.checkNotNull((Object)repository);
            this.setNodeId(nodeId);
            this.setTimestamp(timestamp);
            this.setInitiator(initiator);
        }

        public EventAction getAction() {
            return this.action;
        }

        public RepositoryPayload getRepository() {
            return this.repository;
        }

        public static class RepositoryPayload {
            private final String format;
            private final String name;
            private final String type;

            public RepositoryPayload(String name, Type type, Format format) {
                this.name = (String)Preconditions.checkNotNull((Object)name);
                this.type = ((Type)Preconditions.checkNotNull((Object)type)).getValue();
                this.format = ((Format)Preconditions.checkNotNull((Object)format)).getValue();
            }

            public String getFormat() {
                return this.format;
            }

            public String getName() {
                return this.name;
            }

            public String getType() {
                return this.type;
            }
        }
    }
}

