/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.upload.TempBlobFactory;
import org.sonatype.nexus.repository.upload.internal.BlobStoreMultipartForm;
import org.sonatype.nexus.security.authc.AntiCsrfHelper;

@Named
@Singleton
public class UploadComponentMultipartHelper
extends ComponentSupport {
    private final AntiCsrfHelper antiCsrfHelper;
    private final TempBlobFactory tempBlobFactory;

    @Inject
    public UploadComponentMultipartHelper(AntiCsrfHelper antiCsrfHelper, TempBlobFactory tempBlobFactory) {
        this.antiCsrfHelper = antiCsrfHelper;
        this.tempBlobFactory = (TempBlobFactory)Preconditions.checkNotNull((Object)tempBlobFactory);
    }

    public BlobStoreMultipartForm parse(Repository repository, HttpServletRequest request) throws FileUploadException {
        BlobStoreMultipartForm multipartForm = new BlobStoreMultipartForm();
        TempBlobServletFileUpload upload = new TempBlobServletFileUpload(repository, multipartForm);
        upload.parseRequest(request);
        multipartForm.getFiles().keySet().forEach(assetName -> {
            String string = multipartForm.getFormFields().remove(assetName);
        });
        String token = multipartForm.getFormFields().remove("NX-ANTI-CSRF-TOKEN");
        this.antiCsrfHelper.requireValidToken(request, token);
        return multipartForm;
    }

    private class TempBlobServletFileUpload
    extends ServletFileUpload {
        private final Repository repository;
        private final BlobStoreMultipartForm multipartForm;
        private final Predicate<String> assetPattern = Pattern.compile("^(\\w+\\.)?asset\\d*$").asPredicate();
        private Field field;

        TempBlobServletFileUpload(Repository repository, BlobStoreMultipartForm multipartForm) throws FileUploadException {
            this.repository = repository;
            this.multipartForm = multipartForm;
            try {
                this.field = Class.forName("org.apache.commons.fileupload.FileUploadBase$FileItemIteratorImpl$FileItemStreamImpl").getDeclaredField("name");
                this.field.setAccessible(true);
            }
            catch (Exception e) {
                throw new FileUploadException("Unable to initialize multipart parsing", (Throwable)e);
            }
        }

        /*
         * Unable to fully structure code
         */
        public List<FileItem> parseRequest(RequestContext ctx) throws FileUploadException {
            block8: {
                successful = false;
                try {
                    iter = this.getItemIterator(ctx);
                    while (iter.hasNext()) {
                        this.createField(iter.next());
                    }
                    successful = true;
                    var5_6 = Collections.emptyList();
                    return var5_6;
                }
                catch (FileUploadBase.FileUploadIOException e) {
                    throw (FileUploadException)e.getCause();
                }
                catch (IOException e) {
                    throw new FileUploadException(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (successful) break block8;
                    ** for (tempBlob : this.multipartForm.getFiles().values())
                }
lbl-1000:
                // 1 sources

                {
                    tempBlob.getTempBlob().close();
                    continue;
                }
            }
            throw var4_11;
        }

        private void createField(FileItemStream item) throws FileUploadException {
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (InputStream in = item.openStream();){
                    if (!item.isFormField() || this.assetPattern.test(item.getFieldName()) && item.getContentType() != null) {
                        String fileName = (String)this.field.get(item);
                        this.multipartForm.putFile(item.getFieldName(), new BlobStoreMultipartForm.TempBlobFormField(item.getFieldName(), fileName, UploadComponentMultipartHelper.this.tempBlobFactory.create(this.repository, in, HashAlgorithm.ALL_HASH_ALGORITHMS.values())));
                    } else {
                        this.multipartForm.putFormField(item.getFieldName(), IOUtils.toString((InputStream)in, (String)this.getCharSet(item.getContentType())));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileUploadBase.FileUploadIOException e) {
                throw (FileUploadException)e.getCause();
            }
            catch (IOException e) {
                throw new FileUploadBase.IOFileUploadException(String.format("Processing of %s request failed. %s", "multipart/form-data", e.getMessage()), e);
            }
            catch (IllegalAccessException e) {
                UploadComponentMultipartHelper.this.log.error("Unable to access filename field", (Throwable)e);
            }
        }

        private String getCharSet(String contentType) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(contentType, ';');
            return params.getOrDefault("charset", Charsets.UTF_8.name());
        }
    }
}

