/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.rest.ValidationErrorsException;

public class ValidatingComponentUpload {
    private final UploadDefinition uploadDefinition;
    protected final ComponentUpload componentUpload;
    private final ValidationErrorsException validationErrorsException;

    public ValidatingComponentUpload(UploadDefinition uploadDefinition, ComponentUpload componentUpload) {
        this.uploadDefinition = (UploadDefinition)Preconditions.checkNotNull((Object)uploadDefinition);
        this.componentUpload = (ComponentUpload)Preconditions.checkNotNull((Object)componentUpload);
        this.validationErrorsException = new ValidationErrorsException();
    }

    public ComponentUpload getComponentUpload() {
        this.validate();
        return this.componentUpload;
    }

    private void validate() {
        this.validateAssetPresent();
        this.validateAllowedComponentFields();
        this.validateRequiredComponentFieldPresent();
        this.validateAssetFields();
        this.validateDuplicatesAbsent();
        if (!this.validationErrorsException.getValidationErrors().isEmpty()) {
            throw this.validationErrorsException;
        }
    }

    private void validateAssetPresent() {
        if (this.componentUpload.getAssetUploads().isEmpty()) {
            this.validationErrorsException.withError("No assets found in upload");
        }
    }

    private void validateAllowedComponentFields() {
        this.collectNotAllowedFields(this.componentUpload.getFields(), this.getAllowedComponentFields()).forEach(field -> {
            ValidationErrorsException validationErrorsException = this.validationErrorsException.withError(field, String.format("Unknown component field '%s'", field));
        });
    }

    protected void validateRequiredComponentFieldPresent() {
        this.uploadDefinition.getComponentFields().stream().filter(field -> !field.isOptional()).filter(field -> Strings2.isBlank((String)this.componentUpload.getField(field.getName()))).forEach(field -> {
            ValidationErrorsException validationErrorsException = this.validationErrorsException.withError(field.getName(), String.format("Missing required component field '%s'", field.getDisplayName()));
        });
    }

    private void validateAssetFields() {
        int assetIndex = 1;
        while (assetIndex < this.componentUpload.getAssetUploads().size() + 1) {
            AssetUpload asset = this.componentUpload.getAssetUploads().get(assetIndex - 1);
            this.validatePayloadPresent(asset, assetIndex);
            this.validateAllowedAssetFields(asset, assetIndex);
            this.validateRequiredAssetFieldPresent(asset, assetIndex);
            ++assetIndex;
        }
    }

    private void validateDuplicatesAbsent() {
        List<AssetUpload> uploads = this.componentUpload.getAssetUploads();
        HashMap matches = new HashMap();
        IntStream.range(1, uploads.size() + 1).forEach(i -> {
            AssetUpload upload = (AssetUpload)uploads.get(i - 1);
            if (matches.containsKey(upload.getFields())) {
                this.validationErrorsException.withError(String.format("The assets %s and %s have identical coordinates", matches.get(upload.getFields()), i));
            }
            matches.put(upload.getFields(), i);
        });
    }

    private void validatePayloadPresent(AssetUpload asset, int assetIndex) {
        if (asset.getPayload() == null) {
            this.validationErrorsException.withError("file", String.format("Missing file on asset '%s'", assetIndex));
        }
    }

    private void validateAllowedAssetFields(AssetUpload asset, int assetIndex) {
        this.collectNotAllowedFields(asset.getFields(), this.getAllowedAssetFields()).forEach(field -> {
            ValidationErrorsException validationErrorsException = this.validationErrorsException.withError(field, String.format("Unknown field '%s' on asset '%s'", field, assetIndex));
        });
    }

    private void validateRequiredAssetFieldPresent(AssetUpload asset, int assetIndex) {
        this.uploadDefinition.getAssetFields().stream().filter(field -> !field.isOptional()).filter(field -> Strings2.isBlank((String)asset.getField(field.getName()))).forEach(field -> {
            ValidationErrorsException validationErrorsException = this.validationErrorsException.withError(field.getName(), String.format("Missing required asset field '%s' on '%s'", field.getDisplayName(), assetIndex));
        });
    }

    private Collection<String> collectNotAllowedFields(Map<String, String> fields, Collection<String> allowedFields) {
        Set keys = Optional.ofNullable(fields).map(Map::keySet).orElse(Collections.emptySet());
        return keys.stream().filter(field -> !allowedFields.contains(field)).collect(Collectors.toList());
    }

    private Set<String> getAllowedAssetFields() {
        return this.uploadDefinition.getAssetFields().stream().map(UploadFieldDefinition::getName).collect(Collectors.toSet());
    }

    private Set<String> getAllowedComponentFields() {
        return this.uploadDefinition.getComponentFields().stream().map(UploadFieldDefinition::getName).collect(Collectors.toSet());
    }
}

