/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.repository.view.Content;

public class UploadResponse {
    private final List<String> assetPaths;
    private final Collection<Content> contents;

    public UploadResponse(List<String> assetPaths) {
        this.contents = Collections.emptyList();
        this.assetPaths = (List)Preconditions.checkNotNull(assetPaths);
    }

    public UploadResponse(Collection<Content> contents, List<String> assetPaths) {
        this.contents = (Collection)Preconditions.checkNotNull(contents);
        this.assetPaths = (List)Preconditions.checkNotNull(assetPaths);
    }

    public UploadResponse(Content content, List<String> assetPaths) {
        this.contents = Collections.singletonList((Content)Preconditions.checkNotNull((Object)content));
        this.assetPaths = (List)Preconditions.checkNotNull(assetPaths);
    }

    public List<String> getAssetPaths() {
        return this.assetPaths;
    }

    public Collection<Content> getContents() {
        return this.contents;
    }
}

