/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.importtask.ImportResult;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;

public interface UploadManager {
    public Collection<UploadDefinition> getAvailableDefinitions();

    @Nullable
    public UploadDefinition getByFormat(String var1);

    public UploadResponse handle(Repository var1, HttpServletRequest var2) throws IOException;

    public Content handle(ImportFileConfiguration var1) throws IOException;

    public void handleAfterImport(ImportResult var1) throws IOException;

    public static class UIUploadEvent {
        private final Repository repository;
        private final List<String> assetPaths;

        public UIUploadEvent(Repository repository, List<String> assetPaths) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
            this.assetPaths = (List)Preconditions.checkNotNull(assetPaths);
        }

        public Repository getRepository() {
            return this.repository;
        }

        public List<String> getAssetPaths() {
            return this.assetPaths;
        }

        public String toString() {
            return "UIUploadEvent{repository=" + this.repository + ", assetPaths=" + this.assetPaths + '}';
        }
    }
}

