/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.importtask.ImportResult;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.upload.ValidatingComponentUpload;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.selector.VariableSource;

public interface UploadHandler {
    public UploadResponse handle(Repository var1, ComponentUpload var2) throws IOException;

    public UploadDefinition getDefinition();

    public VariableResolverAdapter getVariableResolverAdapter();

    public ContentPermissionChecker contentPermissionChecker();

    default public void ensurePermitted(String repositoryName, String format, String path, Map<String, String> coordinates) {
        boolean dotSegment = Stream.of(path.split("/")).anyMatch(segment -> segment.equals(".") || segment.equals(".."));
        if (dotSegment) {
            throw new ValidationErrorsException(String.format("Path is not allowed to have '.' or '..' segments: '%s'", path));
        }
        VariableSource variableSource = this.getVariableResolverAdapter().fromCoordinates(format, path, coordinates);
        if (!this.contentPermissionChecker().isPermitted(repositoryName, format, "edit", variableSource)) {
            throw new ValidationErrorsException(String.format("Not authorized for requested path '%s'", path));
        }
    }

    default public ValidatingComponentUpload getValidatingComponentUpload(ComponentUpload componentUpload) {
        return new ValidatingComponentUpload(this.getDefinition(), componentUpload);
    }

    default public Content handle(Repository repository, File content, String path) throws IOException {
        throw new UnsupportedOperationException("Import not supported for " + repository.getFormat().getValue() + " format.");
    }

    default public Content handle(ImportFileConfiguration configuration) throws IOException {
        String format = configuration.getRepository().getFormat().getValue();
        throw new UnsupportedOperationException("Import using hard links not supported for " + format + " format");
    }

    default public void handleAfterImport(ImportResult importResult) throws IOException {
    }

    default public boolean supportsUiUpload() {
        return true;
    }

    default public boolean supportsExportImport() {
        return false;
    }
}

