/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload;

import java.util.Objects;
import org.sonatype.nexus.common.text.Strings2;

public class UploadFieldDefinition {
    private String displayName;
    private String helpText;
    private String name;
    private boolean optional;
    private Type type;
    private String group;

    public UploadFieldDefinition(String name, boolean optional, Type type) {
        this(name, Strings2.capitalize((String)name), null, optional, type, null);
    }

    public UploadFieldDefinition(String name, boolean optional, Type type, String group) {
        this(name, Strings2.capitalize((String)name), null, optional, type, group);
    }

    public UploadFieldDefinition(String name, String helpText, boolean optional, Type type) {
        this(name, Strings2.capitalize((String)name), helpText, optional, type, null);
    }

    public UploadFieldDefinition(String name, String helpText, boolean optional, Type type, String group) {
        this(name, Strings2.capitalize((String)name), helpText, optional, type, group);
    }

    public UploadFieldDefinition(String name, String displayName, String helpText, boolean optional, Type type, String group) {
        this.name = name;
        this.displayName = displayName;
        this.helpText = helpText;
        this.optional = optional;
        this.type = type;
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getGroup() {
        return this.group;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.helpText, this.type, this.group, this.optional});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UploadFieldDefinition other = (UploadFieldDefinition)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        if (!Objects.equals(this.helpText, other.helpText)) {
            return false;
        }
        if (!Objects.equals((Object)this.type, (Object)other.type)) {
            return false;
        }
        if (!Objects.equals(this.group, other.group)) {
            return false;
        }
        return this.optional == other.optional;
    }

    public static enum Type {
        BOOLEAN,
        STRING;

    }
}

