/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadRegexMap;

public class UploadDefinition {
    private final boolean uiUpload;
    private final boolean multipleUpload;
    private final String format;
    private final List<UploadFieldDefinition> componentFields;
    private final List<UploadFieldDefinition> assetFields;
    private final UploadRegexMap regexMap;

    public UploadDefinition(String format, boolean uiUpload, boolean multipleUpload, List<UploadFieldDefinition> componentFields, List<UploadFieldDefinition> assetFields, UploadRegexMap regexMap) {
        this.uiUpload = uiUpload;
        this.multipleUpload = multipleUpload;
        this.format = (String)Preconditions.checkNotNull((Object)format);
        this.componentFields = Collections.unmodifiableList((List)Preconditions.checkNotNull(componentFields));
        this.assetFields = Collections.unmodifiableList((List)Preconditions.checkNotNull(assetFields));
        this.regexMap = regexMap;
    }

    public UploadDefinition(String format, boolean uiUpload, boolean multipleUpload, List<UploadFieldDefinition> componentFields, List<UploadFieldDefinition> assetFields) {
        this(format, uiUpload, multipleUpload, componentFields, assetFields, null);
    }

    public boolean isUiUpload() {
        return this.uiUpload;
    }

    public boolean isMultipleUpload() {
        return this.multipleUpload;
    }

    public String getFormat() {
        return this.format;
    }

    public List<UploadFieldDefinition> getComponentFields() {
        return this.componentFields;
    }

    public List<UploadFieldDefinition> getAssetFields() {
        return this.assetFields;
    }

    @Nullable
    public UploadRegexMap getRegexMap() {
        return this.regexMap;
    }
}

