/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.task;

public class DeletionProgress {
    private long componentCount = 0L;
    private long assetCount = 0L;
    private boolean failed;
    private int attempts = 0;
    private int retryLimit = 0;

    public DeletionProgress() {
    }

    public DeletionProgress(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public long getComponentCount() {
        return this.componentCount;
    }

    public void addComponentCount(long count) {
        this.componentCount += count;
    }

    public long getAssetCount() {
        return this.assetCount;
    }

    public void addAssetCount(long count) {
        this.assetCount += count;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean completed) {
        this.failed = completed;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public void update(DeletionProgress progress) {
        this.failed = progress.isFailed();
        this.componentCount += progress.getComponentCount();
        this.assetCount += progress.getAssetCount();
        if (progress.isFailed()) {
            ++this.attempts;
        }
    }

    public boolean isFinished() {
        return !this.isFailed() || this.getAttempts() >= this.retryLimit;
    }
}

