/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositoryContentSelectorPermission;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorEvaluationException;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
public class ContentPermissionCheckerImpl
extends ComponentSupport
implements ContentPermissionChecker {
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;

    @Inject
    public ContentPermissionCheckerImpl(SecurityHelper securityHelper, SelectorManager selectorManager) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
    }

    @VisibleForTesting
    public boolean isViewPermitted(String repositoryName, String repositoryFormat, String action) {
        return this.securityHelper.anyPermitted(new Permission[]{new RepositoryViewPermission(repositoryFormat, repositoryName, action)});
    }

    @VisibleForTesting
    public boolean isViewPermitted(String repositoryName, String repositoryFormat, String ... actions) {
        return this.securityHelper.anyPermitted((Permission[])ContentPermissionCheckerImpl.permissionsFor(repositoryName, repositoryFormat, actions));
    }

    @VisibleForTesting
    public boolean isViewPermitted(Set<String> repoNames, String repositoryFormat, String ... actions) {
        return this.securityHelper.anyPermitted((Permission[])ContentPermissionCheckerImpl.permissionsFor(repoNames, repositoryFormat, actions));
    }

    private static RepositoryViewPermission[] permissionsFor(String repositoryName, String repositoryFormat, String ... actions) {
        return (RepositoryViewPermission[])ContentPermissionCheckerImpl.permissionsStreamFor(repositoryName, repositoryFormat, actions).toArray(RepositoryViewPermission[]::new);
    }

    private static RepositoryContentSelectorPermission[] contentPermissionsFor(String repositoryName, String repositoryFormat, SelectorConfiguration selectorConfiguration, String ... actions) {
        return (RepositoryContentSelectorPermission[])ContentPermissionCheckerImpl.contentPermissionsStreamFor(selectorConfiguration.getName(), repositoryFormat, repositoryName, actions).toArray(RepositoryContentSelectorPermission[]::new);
    }

    private static RepositoryViewPermission[] permissionsFor(Set<String> repoNames, String repoFormat, String ... actions) {
        return (RepositoryViewPermission[])repoNames.stream().flatMap(repoName -> ContentPermissionCheckerImpl.permissionsStreamFor(repoName, repoFormat, actions)).toArray(RepositoryViewPermission[]::new);
    }

    private static Stream<RepositoryViewPermission> permissionsStreamFor(String repositoryName, String repositoryFormat, String ... actions) {
        return Arrays.stream(actions).map(action -> new RepositoryViewPermission(repositoryFormat, repositoryName, (String)action));
    }

    private static Stream<RepositoryContentSelectorPermission> contentPermissionsStreamFor(String selectorConfigurationName, String repositoryFormat, String repositoryName, String ... actions) {
        return Arrays.stream(actions).map(action -> new RepositoryContentSelectorPermission(selectorConfigurationName, repositoryFormat, repositoryName, Arrays.asList(action)));
    }

    @VisibleForTesting
    public boolean isViewPermitted(Set<String> repositoryNames, String repositoryFormat, String action) {
        RepositoryViewPermission[] perms = ContentPermissionCheckerImpl.permissionsFor(repositoryNames, repositoryFormat, action);
        if (perms.length > 0) {
            return this.securityHelper.anyPermitted((Permission[])perms);
        }
        return false;
    }

    @VisibleForTesting
    public boolean isContentPermitted(String repositoryName, String repositoryFormat, String action, SelectorConfiguration selectorConfiguration, VariableSource variableSource) {
        RepositoryContentSelectorPermission perm = new RepositoryContentSelectorPermission(selectorConfiguration.getName(), repositoryFormat, repositoryName, Arrays.asList(action));
        try {
            return this.securityHelper.anyPermitted(new Permission[]{perm}) && this.selectorManager.evaluate(selectorConfiguration, variableSource);
        }
        catch (SelectorEvaluationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.debug(e.getMessage(), (Throwable)e);
            } else {
                this.log.debug(e.getMessage());
            }
            return false;
        }
    }

    @VisibleForTesting
    public boolean isContentPermittedAnyOf(String repositoryName, String repositoryFormat, SelectorConfiguration selectorConfiguration, VariableSource variableSource, String ... actions) {
        try {
            RepositoryContentSelectorPermission[] permissions = ContentPermissionCheckerImpl.contentPermissionsFor(repositoryName, repositoryFormat, selectorConfiguration, actions);
            return this.securityHelper.anyPermitted((Permission[])permissions) && this.selectorManager.evaluate(selectorConfiguration, variableSource);
        }
        catch (SelectorEvaluationException e) {
            this.logMsgAndMaybeException(e);
            return false;
        }
    }

    @VisibleForTesting
    public boolean isContentPermittedAnyOf(Set<String> repositoryNames, String repositoryFormat, SelectorConfiguration selectorConfiguration, VariableSource variableSource, String ... actions) {
        try {
            Permission[] permissions = (Permission[])repositoryNames.stream().flatMap(repoName -> ContentPermissionCheckerImpl.contentPermissionsStreamFor(selectorConfiguration.getName(), repositoryFormat, repoName, actions)).toArray(Permission[]::new);
            return this.securityHelper.anyPermitted(permissions) && this.selectorManager.evaluate(selectorConfiguration, variableSource);
        }
        catch (SelectorEvaluationException e) {
            this.logMsgAndMaybeException(e);
            return false;
        }
    }

    private void logMsgAndMaybeException(SelectorEvaluationException ex) {
        if (this.log.isTraceEnabled()) {
            this.log.debug(ex.getMessage(), (Throwable)ex);
        } else {
            this.log.debug(ex.getMessage());
        }
    }

    @VisibleForTesting
    public boolean isContentPermitted(Set<String> repositoryNames, String repositoryFormat, String action, SelectorConfiguration selectorConfiguration, VariableSource variableSource) {
        RepositoryContentSelectorPermission[] perms = (RepositoryContentSelectorPermission[])repositoryNames.stream().map(repositoryName -> new RepositoryContentSelectorPermission(selectorConfiguration.getName(), repositoryFormat, (String)repositoryName, Arrays.asList(action))).toArray(RepositoryContentSelectorPermission[]::new);
        if (perms.length > 0) {
            try {
                return this.securityHelper.anyPermitted((Permission[])perms) && this.selectorManager.evaluate(selectorConfiguration, variableSource);
            }
            catch (SelectorEvaluationException e) {
                if (this.log.isTraceEnabled()) {
                    this.log.debug(e.getMessage(), (Throwable)e);
                }
                this.log.debug(e.getMessage());
            }
        }
        return false;
    }

    @Override
    public boolean isPermitted(String repositoryName, String repositoryFormat, String action, VariableSource variableSource) {
        if (this.isViewPermitted(repositoryName, repositoryFormat, action)) {
            return true;
        }
        return this.selectorManager.browse().stream().anyMatch(config -> this.isContentPermitted(repositoryName, repositoryFormat, action, (SelectorConfiguration)config, variableSource));
    }

    @Override
    public boolean isPermittedJexlOnly(String repositoryName, String repositoryFormat, String action, VariableSource variableSource) {
        if (this.isViewPermitted(repositoryName, repositoryFormat, action)) {
            return true;
        }
        return this.selectorManager.browseJexl().stream().anyMatch(config -> this.isContentPermitted(repositoryName, repositoryFormat, action, (SelectorConfiguration)config, variableSource));
    }

    @Override
    public boolean isPermitted(Set<String> repositoryNames, String repositoryFormat, String action, VariableSource variableSource) {
        if (repositoryNames.isEmpty()) {
            return false;
        }
        if (this.isViewPermitted(repositoryNames, repositoryFormat, action)) {
            return true;
        }
        return this.selectorManager.browseActive(repositoryNames, Collections.singletonList(repositoryFormat)).stream().anyMatch(config -> this.isContentPermitted(repositoryNames, repositoryFormat, action, (SelectorConfiguration)config, variableSource));
    }

    @Override
    public boolean isPermittedJexlOnlyAnyOf(String repositoryName, String repositoryFormat, VariableSource variableSource, String ... actions) {
        if (this.isViewPermitted(repositoryName, repositoryFormat, actions)) {
            return true;
        }
        return this.selectorManager.browseJexl().stream().anyMatch(config -> this.isContentPermittedAnyOf(repositoryName, repositoryFormat, (SelectorConfiguration)config, variableSource, actions));
    }

    @Override
    public boolean isPermittedAnyOf(String repositoryName, String repositoryFormat, VariableSource variableSource, String ... actions) {
        if (this.isViewPermitted(repositoryName, repositoryFormat, actions)) {
            return true;
        }
        return this.selectorManager.browse().stream().anyMatch(config -> this.isContentPermittedAnyOf(repositoryName, repositoryFormat, (SelectorConfiguration)config, variableSource, actions));
    }

    @Override
    public boolean isPermittedAnyOf(Set<String> repositoryNames, String repositoryFormat, VariableSource variableSource, String ... actions) {
        if (repositoryNames.isEmpty()) {
            return false;
        }
        if (this.isViewPermitted(repositoryNames, repositoryFormat, actions)) {
            return true;
        }
        return this.selectorManager.browse().stream().anyMatch(config -> this.isContentPermittedAnyOf(repositoryNames, repositoryFormat, (SelectorConfiguration)config, variableSource, actions));
    }
}

