/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.selector.ConstantVariableResolver;
import org.sonatype.nexus.selector.PropertiesResolver;
import org.sonatype.nexus.selector.VariableResolver;
import org.sonatype.nexus.selector.VariableSource;
import org.sonatype.nexus.selector.VariableSourceBuilder;

public abstract class VariableResolverAdapterSupport
implements VariableResolverAdapter {
    protected static final String NAME = "name";
    protected static final String PATH = "path";
    protected static final String FORMAT = "format";
    @Inject
    @Named(value="nexus.orient.enabled")
    public Boolean orientEnabled;

    @Override
    public VariableSource fromRequest(Request request, Repository repository) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        String path = this.orientEnabled != false ? request.getPath().substring(1) : request.getPath();
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)path, new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)repository.getFormat().getValue(), new String[]{FORMAT}));
        this.addFromRequest(builder, request);
        return builder.build();
    }

    protected abstract void addFromRequest(VariableSourceBuilder var1, Request var2);

    @Override
    public VariableSource fromCoordinates(String format, String path, Map<String, String> coordinates) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver(Preconditions.checkNotNull((Object)path), new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver(Preconditions.checkNotNull((Object)format), new String[]{FORMAT}));
        this.addCoordinates(builder, coordinates);
        return builder.build();
    }

    @Override
    public VariableSource fromSourceLookup(SourceLookup sourceLookup, Map<String, Object> asset) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver(Preconditions.checkNotNull((Object)((String)asset.get(NAME))), new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver(Preconditions.checkNotNull((Object)sourceLookup.get((Object)FORMAT)), new String[]{FORMAT}));
        this.addFromSourceLookup(builder, sourceLookup, asset);
        return builder.build();
    }

    @Override
    public VariableSource fromSearchResult(ComponentSearchResult component, AssetSearchResult asset) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)asset.getPath(), new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)component.getFormat(), new String[]{FORMAT}));
        this.addFromSearchResults(builder, component, asset);
        return builder.build();
    }

    protected abstract void addFromSourceLookup(VariableSourceBuilder var1, SourceLookup var2, Map<String, Object> var3);

    protected abstract void addFromSearchResults(VariableSourceBuilder var1, ComponentSearchResult var2, AssetSearchResult var3);

    protected void addCoordinates(VariableSourceBuilder builder, Map<String, String> coordinates) {
        builder.addResolver((VariableResolver)new PropertiesResolver("coordinate", coordinates));
    }

    @Override
    public VariableSource fromPath(String path, String format) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)path, new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)format, new String[]{FORMAT}));
        return builder.build();
    }
}

