/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.security.SecurityFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class SecurityHandler
extends ComponentSupport
implements org.sonatype.nexus.repository.view.handlers.SecurityHandler {
    @VisibleForTesting
    static final String AUTHORIZED_KEY = "security.authorized";
    private final Handler loginsCounterHandler;

    @Inject
    public SecurityHandler(@Named(value="nexus.analytics.loginsCounterHandler") @Nullable @Named(value="nexus.analytics.loginsCounterHandler") @Nullable Handler loginsCounterHandler) {
        this.loginsCounterHandler = loginsCounterHandler;
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        SecurityFacet securityFacet = (SecurityFacet)context.getRepository().facet(SecurityFacet.class);
        if (context.getAttributes().get(AUTHORIZED_KEY) == null) {
            securityFacet.ensurePermitted(context.getRequest());
            context.getAttributes().set(AUTHORIZED_KEY, (Object)true);
            if (this.loginsCounterHandler != null) {
                context.insertHandler(this.loginsCounterHandler);
            }
        }
        return context.proceed();
    }
}

