/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.formfields.SetOfCheckboxesFormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.RepositoryPrivilegeDescriptorSupport;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryView;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryViewRequest;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CPrivilegeBuilder;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.privilege.rest.PrivilegeAction;

@Named(value="repository-view")
@Singleton
public class RepositoryViewPrivilegeDescriptor
extends RepositoryPrivilegeDescriptorSupport<ApiPrivilegeRepositoryView, ApiPrivilegeRepositoryViewRequest> {
    public static final String TYPE = "repository-view";
    public static final String P_FORMAT = "format";
    public static final String P_REPOSITORY = "repository";
    public static final String P_ACTIONS = "actions";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields;
    private static final String P_OPTIONS = "options";

    @Inject
    public RepositoryViewPrivilegeDescriptor(RepositoryManager repositoryManager, List<Format> formats, @Named(value="${nexus.react.privileges:-true}") @Named(value="${nexus.react.privileges:-true}") boolean isReactPrivileges) {
        super(TYPE, repositoryManager, formats);
        this.formFields = ImmutableList.of((Object)new StringTextFormField(P_FORMAT, messages.format(), messages.formatHelp(), true), (Object)new RepositoryCombobox(P_REPOSITORY, messages.repository(), messages.repositoryHelp(), true).includeAnEntryForAllRepositories(), (Object)(isReactPrivileges ? new SetOfCheckboxesFormField(P_ACTIONS, messages.actions(), messages.actionsCheckboxesHelp(), true).withAttribute(P_OPTIONS, (Object)PrivilegeAction.getBreadActionStrings()) : new StringTextFormField(P_ACTIONS, messages.actions(), messages.actionsHelp(), true, "(^(browse|read|edit|add|delete)(,(browse|read|edit|add|delete)){0,4}$)|(^\\*$)")));
    }

    public Permission createPermission(CPrivilege privilege) {
        Preconditions.checkNotNull((Object)privilege);
        String format = this.readProperty(privilege, P_FORMAT, "*");
        String name = this.readProperty(privilege, P_REPOSITORY, "*");
        List actions = this.readListProperty(privilege, P_ACTIONS, "*");
        return new RepositoryViewPermission(format, name, actions);
    }

    public List<FormField> getFormFields() {
        return this.formFields;
    }

    public String getName() {
        return messages.name();
    }

    public static String id(String format, String name, String ... actions) {
        return String.format("nx-%s-%s-%s-%s", TYPE, format, name, Joiner.on((char)',').join((Object[])actions));
    }

    public static CPrivilege privilege(String format, String name, String ... actions) {
        Preconditions.checkArgument((actions.length > 0 ? 1 : 0) != 0);
        return new CPrivilegeBuilder().type(TYPE).id(RepositoryViewPrivilegeDescriptor.id(format, name, actions)).description(String.format("%s for %s repository views", RepositoryViewPrivilegeDescriptor.humanizeActions((String[])actions), RepositoryViewPrivilegeDescriptor.humanizeName((String)name, (String)format))).property(P_FORMAT, format).property(P_REPOSITORY, name).property(P_ACTIONS, actions).create();
    }

    public ApiPrivilegeRepositoryView createApiPrivilegeImpl(Privilege privilege) {
        return new ApiPrivilegeRepositoryView(privilege);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository View")
        public String name();

        @MessageBundle.DefaultMessage(value="Format")
        public String format();

        @MessageBundle.DefaultMessage(value="The format(s) for the repository")
        public String formatHelp();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repository();

        @MessageBundle.DefaultMessage(value="The repository name")
        public String repositoryHelp();

        @MessageBundle.DefaultMessage(value="Actions")
        public String actions();

        @MessageBundle.DefaultMessage(value="A comma-delimited list (without whitespace) of actions allowed with this privilege; options include browse, read, edit, add, delete, and a wildcard (*) <a href='https://links.sonatype.com/products/nxrm3/docs/privileges' target='_blank'>Help</a>")
        public String actionsHelp();

        @MessageBundle.DefaultMessage(value="The actions you wish to allow")
        public String actionsCheckboxesHelp();
    }
}

