/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.security.RepositoryViewPrivilegeDescriptor;
import org.sonatype.nexus.security.config.MutableSecurityContributor;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfigurationManager;

public class RepositoryFormatSecurityContributor
extends MutableSecurityContributor {
    private final Format format;

    public RepositoryFormatSecurityContributor(Format format) {
        this.format = (Format)Preconditions.checkNotNull((Object)format);
    }

    protected void initial(SecurityConfiguration model) {
        String format = this.format.getValue();
        this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, "*", "*"));
        this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, "*", "browse"));
        this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, "*", "read"));
        this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, "*", "edit"));
        this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, "*", "add"));
        this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, "*", "delete"));
    }

    public void add(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String format = repository.getFormat().getValue();
        String name = repository.getName();
        this.apply((model, configurationManager) -> {
            this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, name, "*"));
            this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, name, "browse"));
            this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, name, "read"));
            this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, name, "edit"));
            this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, name, "add"));
            this.maybeAddPrivilege(model, RepositoryViewPrivilegeDescriptor.privilege(format, name, "delete"));
        });
    }

    public void remove(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String format = repository.getFormat().getValue();
        String name = repository.getName();
        List<String> privilegeIds = Arrays.asList(RepositoryViewPrivilegeDescriptor.id(format, name, "*"), RepositoryViewPrivilegeDescriptor.id(format, name, "browse"), RepositoryViewPrivilegeDescriptor.id(format, name, "read"), RepositoryViewPrivilegeDescriptor.id(format, name, "edit"), RepositoryViewPrivilegeDescriptor.id(format, name, "add"), RepositoryViewPrivilegeDescriptor.id(format, name, "delete"));
        this.apply((model, configurationManager) -> {
            privilegeIds.forEach(arg_0 -> ((SecurityConfiguration)model).removePrivilege(arg_0));
            privilegeIds.forEach(arg_0 -> ((SecurityConfigurationManager)configurationManager).cleanRemovedPrivilege(arg_0));
        });
    }
}

