/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.formfields.SelectorComboFormField;
import org.sonatype.nexus.formfields.SetOfCheckboxesFormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.RepositoryContentSelectorPermission;
import org.sonatype.nexus.repository.security.RepositoryPrivilegeDescriptorSupport;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryContentSelector;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryContentSelectorRequest;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CPrivilegeBuilder;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.privilege.rest.PrivilegeAction;
import org.sonatype.nexus.selector.SelectorManager;

@Named(value="repository-content-selector")
@Singleton
public class RepositoryContentSelectorPrivilegeDescriptor
extends RepositoryPrivilegeDescriptorSupport<ApiPrivilegeRepositoryContentSelector, ApiPrivilegeRepositoryContentSelectorRequest> {
    public static final String INVALID_SELECTOR = "\"Invalid selector '%s' supplied.\"";
    public static final String TYPE = "repository-content-selector";
    public static final String P_CONTENT_SELECTOR = "contentSelector";
    public static final String P_REPOSITORY = "repository";
    public static final String P_ACTIONS = "actions";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields;
    private final SelectorManager selectorManager;
    private static final String P_OPTIONS = "options";

    @Inject
    public RepositoryContentSelectorPrivilegeDescriptor(RepositoryManager repositoryManager, SelectorManager selectorManager, List<Format> formats, @Named(value="${nexus.react.privileges:-true}") @Named(value="${nexus.react.privileges:-true}") boolean isReactPrivileges) {
        super(TYPE, repositoryManager, formats);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.formFields = ImmutableList.of((Object)new SelectorComboFormField(P_CONTENT_SELECTOR, messages.contentSelector(), messages.contentSelectorHelp(), true), (Object)new RepositoryCombobox(P_REPOSITORY, messages.repository(), messages.repositoryHelp(), true).includeEntriesForAllFormats(), (Object)(isReactPrivileges ? new SetOfCheckboxesFormField(P_ACTIONS, messages.actions(), messages.actionsCheckboxesHelp(), true).withAttribute(P_OPTIONS, (Object)PrivilegeAction.getBreadActionStrings()) : new StringTextFormField(P_ACTIONS, messages.actions(), messages.actionsHelp(), true, "(^(browse|read|edit|add|delete)(,(browse|read|edit|add|delete)){0,4}$)|(^\\*$)")));
    }

    public Permission createPermission(CPrivilege privilege) {
        Preconditions.checkNotNull((Object)privilege);
        String contentSelector = this.readProperty(privilege, P_CONTENT_SELECTOR, "*");
        String name = this.readProperty(privilege, P_REPOSITORY, "*");
        List actions = this.readListProperty(privilege, P_ACTIONS, "*");
        RepositorySelector selector = RepositorySelector.fromSelector(name);
        return new RepositoryContentSelectorPermission(contentSelector, selector.getFormat(), selector.getName(), actions);
    }

    public List<FormField> getFormFields() {
        return this.formFields;
    }

    public String getName() {
        return messages.name();
    }

    public static String id(String contentSelector, String format, String name, String ... actions) {
        return String.format("nx-%s-%s-%s-%s-%s", TYPE, contentSelector, format, name, Joiner.on((char)',').join((Object[])actions));
    }

    public static CPrivilege privilege(String contentSelector, String format, String name, String ... actions) {
        Preconditions.checkArgument((actions.length > 0 ? 1 : 0) != 0);
        RepositorySelector selector = RepositorySelector.fromNameAndFormat(name, format);
        return new CPrivilegeBuilder().type(TYPE).id(RepositoryContentSelectorPrivilegeDescriptor.id(contentSelector, format, name, actions)).description(String.format("%s for %s repository content selector %s", RepositoryContentSelectorPrivilegeDescriptor.humanizeActions((String[])actions), selector.humanizeSelector(), contentSelector)).property(P_CONTENT_SELECTOR, contentSelector).property(P_REPOSITORY, selector.toSelector()).property(P_ACTIONS, actions).create();
    }

    public ApiPrivilegeRepositoryContentSelector createApiPrivilegeImpl(Privilege privilege) {
        return new ApiPrivilegeRepositoryContentSelector(privilege);
    }

    @Override
    public void validate(ApiPrivilegeRepositoryContentSelectorRequest apiPrivilege) {
        super.validate(apiPrivilege);
        this.validateContentSelector(apiPrivilege);
    }

    protected void validateContentSelector(ApiPrivilegeRepositoryContentSelectorRequest apiPrivilege) {
        String cs = apiPrivilege.getContentSelector();
        if (!this.selectorManager.findByName(cs).isPresent()) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)String.format(INVALID_SELECTOR, apiPrivilege.getContentSelector()), "application/json");
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository Content Selector")
        public String name();

        @MessageBundle.DefaultMessage(value="Content Selector")
        public String contentSelector();

        @MessageBundle.DefaultMessage(value="The content selector for the repository")
        public String contentSelectorHelp();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repository();

        @MessageBundle.DefaultMessage(value="The repository or repositories to grant access")
        public String repositoryHelp();

        @MessageBundle.DefaultMessage(value="Actions")
        public String actions();

        @MessageBundle.DefaultMessage(value="A comma-delimited list (without whitespace) of actions allowed with this privilege; options include browse, read, edit, add, delete, and a wildcard (*) <a href='https://links.sonatype.com/products/nxrm3/docs/privileges' target='_blank'>Help</a>")
        public String actionsHelp();

        @MessageBundle.DefaultMessage(value="The actions you wish to allow")
        public String actionsCheckboxesHelp();
    }
}

