/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.security.authz.WildcardPermission2;

public class RepositoryAdminPermission
extends WildcardPermission2 {
    public static final String SYSTEM = "nexus";
    public static final String DOMAIN = "repository-admin";
    private final String format;
    private final String name;
    private final List<String> actions;

    public RepositoryAdminPermission(String format, String name, List<String> actions) {
        this.format = (String)Preconditions.checkNotNull((Object)format);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.actions = (List)Preconditions.checkNotNull(actions);
        this.setParts((List)ImmutableList.of((Object)SYSTEM, (Object)DOMAIN, (Object)format, (Object)name), actions);
    }

    public RepositoryAdminPermission(String format, String name, String ... actions) {
        this(format, name, Arrays.asList(actions));
    }

    public RepositoryAdminPermission(Repository repository, String ... actions) {
        this(repository.getFormat().getValue(), repository.getName(), Arrays.asList(actions));
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getActions() {
        return this.actions;
    }
}

