/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpgUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GpgUtils.class);
    private static final char[] EMPTY_PASSPHRASE = new char[0];
    private static final String BC_PROVIDER = "BC";

    private GpgUtils() {
    }

    public static boolean isConfigured(String secretKey, @Nullable String passphrase) {
        if (StringUtils.isBlank((String)secretKey)) {
            return false;
        }
        try {
            PBESecretKeyDecryptor bc = GpgUtils.getSecretKeyDecryptor(passphrase);
            PGPSecretKey pgpSecretKey = GpgUtils.readSecretKey(secretKey);
            PGPPrivateKey pgpPrivateKey = pgpSecretKey.extractPrivateKey(bc);
            return Objects.nonNull(pgpPrivateKey);
        }
        catch (IOException | PGPException e) {
            LOG.warn("GPG key configured, but unexpected error occurred while trying to use it. Please check your keypair and passphrase.", e);
            return false;
        }
    }

    public static byte[] signExternal(InputStream input, String secretKey, @Nullable String passphrase) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            PGPSignatureGenerator sigGenerator = GpgUtils.initPgpSignatureGenerator(secretKey, passphrase, 0);
            Throwable throwable = null;
            Object var6_8 = null;
            try (ArmoredOutputStream aOut = new ArmoredOutputStream((OutputStream)buffer);){
                BCPGOutputStream bOut = new BCPGOutputStream((OutputStream)aOut);
                sigGenerator.update(ByteStreams.toByteArray((InputStream)input));
                sigGenerator.generate().encode((OutputStream)bOut);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
        return buffer.toByteArray();
    }

    public static byte[] signInline(String input, String secretKey, String passphrase) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            PGPSecretKey signKey = GpgUtils.readSecretKey(secretKey);
            PGPSignatureGenerator sigGenerator = GpgUtils.initPgpSignatureGenerator(secretKey, passphrase, 1);
            Iterator userIds = signKey.getUserIDs();
            if (userIds.hasNext()) {
                PGPSignatureSubpacketGenerator sigSubpacketGenerator = new PGPSignatureSubpacketGenerator();
                sigSubpacketGenerator.setSignerUserID(false, (String)userIds.next());
                sigGenerator.setHashedSubpackets(sigSubpacketGenerator.generate());
            }
            String[] lines = input.split("\r?\n");
            Throwable throwable = null;
            Object var9_11 = null;
            try (ArmoredOutputStream aOut = new ArmoredOutputStream((OutputStream)buffer);){
                aOut.beginClearText(8);
                boolean firstLine = true;
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    String sigLine = String.valueOf(firstLine ? "" : "\r\n") + line.replaceAll("\\s*$", "");
                    sigGenerator.update(sigLine.getBytes(StandardCharsets.UTF_8));
                    aOut.write((String.valueOf(line) + "\n").getBytes(StandardCharsets.UTF_8));
                    firstLine = false;
                    ++n2;
                }
                aOut.endClearText();
                sigGenerator.generate().encode((OutputStream)new BCPGOutputStream((OutputStream)aOut));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
        return buffer.toByteArray();
    }

    public static PGPPublicKey getPublicKey(String secretKey) throws IOException {
        PGPSecretKey signKey = GpgUtils.readSecretKey(secretKey);
        return signKey.getPublicKey();
    }

    /*
     * Unable to fully structure code
     */
    private static PGPSecretKey readSecretKey(String secretKey) throws IOException {
        try {
            var1_1 = null;
            var2_4 = null;
            try {
                decoderStream = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(secretKey.getBytes(StandardCharsets.UTF_8)));
                try {
                    pgpSec = new PGPSecretKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    keyRings = pgpSec.getKeyRings();
                    while (true) {
                        keyRing = (PGPSecretKeyRing)keyRings.next();
                        keys = keyRing.getSecretKeys();
                        while (keys.hasNext()) {
                            key = (PGPSecretKey)keys.next();
                            if (!key.isSigningKey()) continue;
                            return key;
                        }
                        break;
                    }
                }
                finally {
                    if (keyRings.hasNext()) ** continue;
                }
            }
            catch (Throwable var2_5) {
                if (var1_1 == null) {
                    var1_1 = var2_5;
                } else if (var1_1 != var2_5) {
                    var1_1.addSuppressed(var2_5);
                }
                throw var1_1;
            }
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Can't find signing key in key ring.");
    }

    private static PGPSignatureGenerator initPgpSignatureGenerator(String secretKey, String passphrase, int pgpSignature) throws IOException, PGPException {
        PBESecretKeyDecryptor keyDecryptor = GpgUtils.getSecretKeyDecryptor(passphrase);
        PGPSecretKey signKey = GpgUtils.readSecretKey(secretKey);
        PGPPrivateKey privateKey = signKey.extractPrivateKey(keyDecryptor);
        PGPSignatureGenerator sigGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(signKey.getPublicKey().getAlgorithm(), 8).setProvider(BC_PROVIDER));
        sigGenerator.init(pgpSignature, privateKey);
        return sigGenerator;
    }

    private static PBESecretKeyDecryptor getSecretKeyDecryptor(String passphrase) throws PGPException {
        char[] pass = StringUtils.isNotBlank((String)passphrase) ? passphrase.toCharArray() : EMPTY_PASSPHRASE;
        return new JcePBESecretKeyDecryptorBuilder().setProvider(BC_PROVIDER).build(pass);
    }

    public static class SigningConfig {
        private String keypair;
        private String passphrase;

        public String getKeypair() {
            return this.keypair;
        }

        public void setKeypair(String keypair) {
            this.keypair = keypair;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public void setPassphrase(String passphrase) {
            this.passphrase = passphrase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SigningConfig that = (SigningConfig)o;
            return Objects.equals(this.keypair, that.keypair) && Objects.equals(this.passphrase, that.passphrase);
        }

        public int hashCode() {
            return Objects.hash(this.keypair, this.passphrase);
        }
    }
}

