/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql.query.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.sonatype.nexus.repository.search.sql.query.syntax.StringTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Term;

public class TermCollection
implements Term {
    private final Collection<StringTerm> terms;

    private TermCollection(Collection<StringTerm> terms) {
        this.terms = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(terms)));
    }

    public Collection<StringTerm> get() {
        return Collections.unmodifiableCollection(this.terms);
    }

    public int hashCode() {
        return Objects.hash(this.terms);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TermCollection other = (TermCollection)obj;
        return Objects.equals(this.terms, other.terms);
    }

    public String toString() {
        return "TermCollection [terms=" + this.terms + "]";
    }

    public static Term create(Collection<StringTerm> terms) {
        if (terms.size() == 1) {
            return (Term)Iterables.getOnlyElement(terms);
        }
        return new TermCollection(terms);
    }

    public static Term create(StringTerm ... terms) {
        if (terms.length == 1) {
            return terms[0];
        }
        return new TermCollection(Arrays.asList(terms));
    }
}

