/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql.query.syntax;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sonatype.nexus.repository.rest.sql.SearchField;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.Term;

public class SqlPredicate
implements Expression {
    private final Operand operand;
    private final SearchField searchField;
    private final Term term;

    public SqlPredicate(Operand operand, SearchField searchField, Term term) {
        this.operand = (Operand)((Object)Preconditions.checkNotNull((Object)((Object)operand)));
        this.searchField = (SearchField)((Object)Preconditions.checkNotNull((Object)((Object)searchField)));
        this.term = (Term)Preconditions.checkNotNull((Object)term);
    }

    @Override
    public Operand operand() {
        return this.operand;
    }

    public SearchField getSearchField() {
        return this.searchField;
    }

    public Term getTerm() {
        return this.term;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operand, this.searchField, this.term});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlPredicate other = (SqlPredicate)obj;
        return this.operand == other.operand && this.searchField == other.searchField && Objects.equals(this.term, other.term);
    }

    public String toString() {
        return "SqlPredicate [searchField=" + (Object)((Object)this.searchField) + ", operand=" + (Object)((Object)this.operand) + ", term=" + this.term + "]";
    }
}

