/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql.query.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;

public class SqlClause
implements Expression {
    private final Operand operand;
    private final List<Expression> expressions;

    private SqlClause(Operand operand, List<? extends Expression> expressions) {
        this.operand = (Operand)((Object)Preconditions.checkNotNull((Object)((Object)operand)));
        Preconditions.checkArgument((operand == Operand.AND || operand == Operand.OR ? 1 : 0) != 0, (Object)("Unexpected operand: " + operand.toString()));
        Preconditions.checkArgument((expressions.size() > 1 ? 1 : 0) != 0, (Object)"Must have at least 2 expressions");
        this.expressions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(expressions)));
    }

    public List<Expression> expressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    @Override
    public Operand operand() {
        return this.operand;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operand, this.expressions});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlClause other = (SqlClause)obj;
        return this.operand == other.operand && Objects.equals(this.expressions, other.expressions);
    }

    public String toString() {
        return this.expressions.stream().map(Object::toString).collect(Collectors.joining(String.valueOf(' ') + this.operand.toString() + ' ', "(", ")"));
    }

    public static Expression create(Operand operand, Expression ... expressions) {
        if (expressions.length == 1) {
            return expressions[0];
        }
        return new SqlClause(operand, Arrays.asList(expressions));
    }

    public static Expression create(Operand operand, List<? extends Expression> expressions) {
        if (expressions.size() == 1) {
            return (Expression)Iterables.getOnlyElement(expressions);
        }
        return new SqlClause(operand, expressions);
    }
}

