/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.ValidationErrorsException;

public abstract class SqlSearchValidationSupport
extends ComponentSupport {
    private static final char ZERO_OR_MORE_CHARACTERS = '*';
    private static final char ANY_CHARACTER = '?';
    private static final int MIN_ALLOWED_SYMBOLS_TO_SEARCH = 3;

    protected Collection<String> getValidTokens(Collection<String> tokens) {
        String errorMsg;
        ValidationErrorsException validation = new ValidationErrorsException();
        LinkedHashSet<String> validTokens = new LinkedHashSet<String>(tokens);
        Set invalidTokens = tokens.stream().filter(Objects::nonNull).filter(SqlSearchValidationSupport::hasLeadingWildcard).collect(Collectors.toSet());
        if (!invalidTokens.isEmpty()) {
            errorMsg = "Leading wildcards are prohibited";
            validation.withError(errorMsg);
            this.log.debug("{} for tokens: {}", (Object)errorMsg, invalidTokens);
            validTokens.removeAll(invalidTokens);
        }
        if (!(invalidTokens = tokens.stream().filter(Objects::nonNull).filter(SqlSearchValidationSupport::hasLeadingSpecialCharacterAndWildcard).collect(Collectors.toSet())).isEmpty()) {
            errorMsg = "Searches cannot begin with a special character followed by a wildcard";
            validation.withError(errorMsg);
            this.log.debug("{} for tokens: {}", (Object)errorMsg, invalidTokens);
            validTokens.removeAll(invalidTokens);
        }
        if (!(invalidTokens = tokens.stream().filter(Objects::nonNull).filter(SqlSearchValidationSupport::notEnoughSymbols).collect(Collectors.toSet())).isEmpty()) {
            errorMsg = String.format("%d characters or more are required with a trailing wildcard (*)", 3);
            validation.withError(errorMsg);
            this.log.debug("{} for tokens: {}", (Object)errorMsg, invalidTokens);
            validTokens.removeAll(invalidTokens);
        }
        if (validTokens.isEmpty()) {
            this.log.debug("No valid search tokens");
            throw validation;
        }
        return validTokens;
    }

    private static boolean hasLeadingWildcard(String token) {
        String trimmedToken = token.trim();
        return trimmedToken.length() > 0 && SqlSearchValidationSupport.isWildcard(trimmedToken.charAt(0));
    }

    private static boolean hasLeadingSpecialCharacterAndWildcard(String token) {
        String trimmedToken = token.trim();
        if (trimmedToken.length() < 2) {
            return false;
        }
        char firstChar = trimmedToken.charAt(0);
        return firstChar != '\\' && !Character.isLetterOrDigit(firstChar) && SqlSearchValidationSupport.isWildcard(trimmedToken.charAt(1));
    }

    private static boolean isWildcard(char character) {
        return character == '*' || character == '?';
    }

    private static Pair<Boolean, Integer> checkTrailingAsterisk(String token) {
        String result = token.replace("\\*", "");
        boolean trailingAsteriskWildcard = result.endsWith("*");
        result = token.replace("*", "");
        return Pair.of((Object)trailingAsteriskWildcard, (Object)result.length());
    }

    private static boolean notEnoughSymbols(String token) {
        String trimmedToken = token.trim();
        Pair<Boolean, Integer> wildcard = SqlSearchValidationSupport.checkTrailingAsterisk(trimmedToken);
        if (((Boolean)wildcard.getKey()).booleanValue()) {
            return (Integer)wildcard.getValue() < 3;
        }
        return false;
    }
}

