/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.rest.sql.SearchField;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SearchMappingService;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContribution;
import org.sonatype.nexus.repository.search.sql.SqlSearchValidationSupport;
import org.sonatype.nexus.repository.search.sql.query.syntax.ExactTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.LenientTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlClause;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlPredicate;
import org.sonatype.nexus.repository.search.sql.query.syntax.StringTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Term;
import org.sonatype.nexus.repository.search.sql.query.syntax.TermCollection;
import org.sonatype.nexus.repository.search.sql.query.syntax.WildcardTerm;

public abstract class SqlSearchQueryContributionSupport
extends SqlSearchValidationSupport
implements SqlSearchQueryContribution {
    private static final String QUOTE = "\"";
    protected SearchMappingService mappingService;

    @Inject
    public void init(SearchMappingService mappingService) {
        this.mappingService = (SearchMappingService)Preconditions.checkNotNull((Object)mappingService);
    }

    @Override
    public Optional<Expression> createPredicate(@Nullable SearchFilter filter) {
        Optional<SearchField> field = this.getField(filter);
        this.log.debug("Mapping for {} is {}", (Object)filter, field);
        if (filter == null || !field.isPresent()) {
            return Optional.empty();
        }
        boolean exact = this.isExact(filter);
        return Optional.ofNullable(filter).map(SearchFilter::getValue).filter(Objects::nonNull).map(String::trim).map(query -> this.split((String)query).map(tokens -> this.tokenize(exact, (String)tokens)).map(TermCollection::create).map(terms -> new SqlPredicate(Operand.EQ, (SearchField)((Object)((Object)((Object)field.get()))), (Term)terms)).collect(Collectors.toList())).map(expressions -> SqlClause.create(Operand.OR, expressions));
    }

    protected Stream<String> split(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Stream.of("");
        }
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        char[] chars = value.toCharArray();
        StringBuilder token = new StringBuilder();
        boolean quoted = false;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\\') {
                token.append(c);
                if (i + 1 < chars.length) {
                    token.append(chars[++i]);
                }
            } else if (c == '\"') {
                if (quoted) {
                    tokens.add(token.toString().trim());
                    token = new StringBuilder();
                    quoted = false;
                } else {
                    quoted = true;
                }
            } else if (!quoted && c == ' ') {
                tokens.add(token.toString().trim());
                token = new StringBuilder();
            } else {
                token.append(c);
            }
            ++i;
        }
        if (Strings2.notBlank((String)token.toString())) {
            tokens.add(token.toString().trim());
        }
        return this.getValidTokens(tokens).stream();
    }

    protected Collection<StringTerm> tokenize(boolean exact, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.singleton(new ExactTerm(""));
        }
        LinkedHashSet<StringTerm> tokens = new LinkedHashSet<StringTerm>();
        char[] chars = value.toCharArray();
        StringBuilder token = new StringBuilder();
        boolean quoted = false;
        boolean terminated = false;
        boolean terminalWildcard = false;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\\') {
                if (i + 1 < chars.length) {
                    token.append(chars[++i]);
                }
            } else if (c == '\"') {
                if (quoted) {
                    this.doCreateMatchTerm(exact, token).ifPresent(tokens::add);
                    token = new StringBuilder();
                    quoted = false;
                } else {
                    quoted = true;
                }
            } else if (!(quoted || c != ' ' && c != '*' && c != '?')) {
                terminalWildcard |= c == '*' || c == '?';
                terminated = true;
            } else if (terminated) {
                this.create(exact, terminalWildcard, token.toString().trim()).ifPresent(tokens::add);
                terminated = false;
                terminalWildcard = false;
                token = new StringBuilder();
                token.append(c);
            } else {
                token.append(c);
            }
            ++i;
        }
        this.create(exact, terminalWildcard, token.toString().trim()).ifPresent(tokens::add);
        return tokens;
    }

    private Optional<StringTerm> create(boolean exact, boolean terminalWildcard, String token) {
        if (!terminalWildcard) {
            return this.doCreateMatchTerm(exact, token);
        }
        return Optional.of(new WildcardTerm(token));
    }

    private Optional<StringTerm> doCreateMatchTerm(boolean exact, CharSequence value) {
        return Optional.of(value).map(CharSequence::toString).map(String::trim).filter(Strings2::notBlank).map(t -> this.createMatchTerm(exact, (String)t));
    }

    protected StringTerm createMatchTerm(boolean exact, String value) {
        return exact ? new ExactTerm(value) : new LenientTerm(value);
    }

    protected static String maybeTrimQuotes(String term) {
        term = StringUtils.removeEnd((String)term, (String)QUOTE);
        term = StringUtils.removeStart((String)term, (String)QUOTE);
        return term;
    }

    protected boolean isExact(@Nullable SearchFilter filter) {
        return Optional.ofNullable(filter).map(SearchFilter::getProperty).map(this.mappingService::isExactMatch).orElse(false);
    }

    protected Optional<SearchField> getField(@Nullable SearchFilter filter) {
        return Optional.ofNullable(filter).map(SearchFilter::getProperty).flatMap(this.mappingService::getSearchField);
    }
}

