/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.rest.sql.SearchField;

@Named
@Singleton
public class SearchMappingService {
    private final Map<String, SearchField> attributeToField = new HashMap<String, SearchField>();
    private final Map<String, Boolean> attributeToExactMatch = new HashMap<String, Boolean>();

    @Inject
    public SearchMappingService(List<SearchMappings> searchMappings) {
        ((List)Preconditions.checkNotNull(searchMappings)).stream().map(SearchMappings::get).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false)).forEach(mapping -> {
            this.attributeToField.put(mapping.getAttribute(), mapping.getField());
            this.attributeToExactMatch.put(mapping.getAttribute(), mapping.isExactMatch());
            this.attributeToField.putIfAbsent(mapping.getAlias(), mapping.getField());
            this.attributeToExactMatch.put(mapping.getAlias(), mapping.isExactMatch());
        });
    }

    public Optional<SearchField> getSearchField(String identifier) {
        return Optional.ofNullable(this.attributeToField.get(identifier));
    }

    public boolean isExactMatch(String identifier) {
        return Optional.ofNullable(this.attributeToExactMatch.get(identifier)).orElse(Boolean.FALSE);
    }
}

