/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.selector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.elasticsearch.script.AbstractSearchScript;
import org.elasticsearch.search.lookup.SourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.selector.VariableSource;

public class ContentAuthPluginScript
extends AbstractSearchScript {
    public static final String NAME = "content_auth";
    private static final Logger log = LoggerFactory.getLogger(ContentAuthPluginScript.class);
    private final Subject subject;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final ContentPermissionChecker contentPermissionChecker;
    private final RepositoryManager repositoryManager;
    private final boolean contentAuthSleep;

    public ContentAuthPluginScript(Subject subject, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, RepositoryManager repositoryManager, boolean contentAuthSleep) {
        this.subject = (Subject)Preconditions.checkNotNull((Object)subject);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.contentAuthSleep = contentAuthSleep;
    }

    public Object run() {
        SubjectThreadState threadState = new SubjectThreadState(this.subject);
        threadState.bind();
        try {
            SourceLookup sourceLookup = this.getSourceLookup();
            String format = (String)Preconditions.checkNotNull((Object)sourceLookup.get((Object)"format"));
            String repositoryName = (String)Preconditions.checkNotNull((Object)sourceLookup.get((Object)"repository_name"));
            Object variableResolverAdapter = this.variableResolverAdapterManager.get(format);
            List assets = (List)sourceLookup.getOrDefault((Object)"assets", Collections.emptyList());
            if (assets != null && !assets.isEmpty()) {
                Map asset = (Map)assets.get(0);
                VariableSource variableSource = variableResolverAdapter.fromSourceLookup(sourceLookup, asset);
                HashSet<String> repoNames = new HashSet<String>();
                repoNames.add(repositoryName);
                repoNames.addAll(this.repositoryManager.findContainingGroups(repositoryName));
                Boolean bl = this.contentPermissionChecker.isPermitted(repoNames, format, "read", variableSource);
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            threadState.clear();
            if (this.contentAuthSleep) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    log.error("Thread.sleep interruped", (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    protected SourceLookup getSourceLookup() {
        return this.source();
    }
}

