/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.selector;

import com.google.common.base.Preconditions;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptModule;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.query.SearchSubjectHelper;
import org.sonatype.nexus.repository.search.selector.ContentAuthPluginScriptFactory;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;

public class ContentAuthPlugin
extends Plugin {
    private static ContentPermissionChecker contentPermissionChecker;
    private static VariableResolverAdapterManager variableResolverAdapterManager;
    private static SearchSubjectHelper searchSubjectHelper;
    private static RepositoryManager repositoryManager;
    private static boolean contentAuthSleep;

    public ContentAuthPlugin() {
        Preconditions.checkNotNull((Object)contentPermissionChecker);
        Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        Preconditions.checkNotNull((Object)((Object)searchSubjectHelper));
        Preconditions.checkNotNull((Object)repositoryManager);
    }

    public String name() {
        return "content-auth-plugin";
    }

    public String description() {
        return "ES plugin for working with content selectors";
    }

    public void onModule(ScriptModule module) {
        module.registerScript("content_auth", ContentAuthPluginScriptFactory.class);
    }

    public static void setDependencies(ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, SearchSubjectHelper searchSubjectHelper, RepositoryManager repositoryManager, boolean contentAuthSleep) {
        ContentAuthPlugin.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        ContentAuthPlugin.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        ContentAuthPlugin.searchSubjectHelper = (SearchSubjectHelper)((Object)Preconditions.checkNotNull((Object)((Object)searchSubjectHelper)));
        ContentAuthPlugin.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        ContentAuthPlugin.contentAuthSleep = contentAuthSleep;
    }

    public static ContentPermissionChecker getContentPermissionChecker() {
        return contentPermissionChecker;
    }

    public static VariableResolverAdapterManager getVariableResolverAdapterManager() {
        return variableResolverAdapterManager;
    }

    public static SearchSubjectHelper getSearchSubjectHelper() {
        return searchSubjectHelper;
    }

    public static RepositoryManager getRepositoryManager() {
        return repositoryManager;
    }

    public static boolean getContentAuthSleep() {
        return contentAuthSleep;
    }
}

