/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.query;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.query.SearchResultComponentGenerator;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.selector.VariableSource;

public abstract class SearchResultComponentGeneratorSupport
extends ComponentSupport
implements SearchResultComponentGenerator {
    final VariableResolverAdapterManager variableResolverAdapterManager;
    final RepositoryManager repositoryManager;
    final ContentPermissionChecker contentPermissionChecker;

    public SearchResultComponentGeneratorSupport(VariableResolverAdapterManager variableResolverAdapterManager, RepositoryManager repositoryManager, ContentPermissionChecker contentPermissionChecker) {
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
    }

    protected String getPrivilegedRepositoryName(ComponentSearchResult source) {
        String repositoryName = source.getRepositoryName();
        String repositoryFormat = source.getFormat();
        List<AssetSearchResult> assets = source.getAssets();
        if (assets != null && !assets.isEmpty()) {
            Object variableResolverAdapter = this.variableResolverAdapterManager.get(repositoryFormat);
            VariableSource variableSource = variableResolverAdapter.fromSearchResult(source, assets.get(0));
            List repositoryNames = this.repositoryManager.findContainingGroups(repositoryName);
            repositoryNames.add(0, repositoryName);
            for (String name : repositoryNames) {
                if (!this.contentPermissionChecker.isPermitted(name, repositoryFormat, "browse", variableSource)) continue;
                return name;
            }
        }
        return repositoryName;
    }
}

