/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.query;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.query.DefaultElasticSearchContribution;

@Named(value="repository_name")
@Singleton
public class RepositoryElasticSearchContribution
extends DefaultElasticSearchContribution {
    public static final String NAME = "repository_name";
    private final RepositoryManager repositoryManager;

    @Inject
    public RepositoryElasticSearchContribution(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    @Override
    public void contribute(Consumer<QueryBuilder> query, String type, String value) {
        Optional groupFacet;
        if (value == null) {
            return;
        }
        Repository repository = this.repositoryManager.get(value);
        if (repository != null && (groupFacet = repository.optionalFacet(GroupFacet.class)).isPresent()) {
            List<Repository> members = ((GroupFacet)groupFacet.get()).leafMembers();
            query.accept((QueryBuilder)QueryBuilders.termsQuery((String)type, (String[])((String[])members.stream().map(Repository::getName).toArray(String[]::new))));
            return;
        }
        super.contribute(query, type, value);
    }
}

