/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriInfo;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.SearchMapping;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.search.BlankValueSearchQueryFilter;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.query.ElasticSearchContribution;
import org.sonatype.nexus.repository.search.query.RepositoryQueryBuilder;
import org.sonatype.nexus.repository.search.query.SearchFilter;

@Named
@Singleton
public class ElasticSearchUtils
extends ComponentSupport {
    public static final String CONTINUATION_TOKEN = "continuationToken";
    public static final String SORT_FIELD = "sort";
    public static final String SORT_DIRECTION = "direction";
    private static final String ASSET_PREFIX = "assets.";
    private static final String CI_SUFFIX = ".case_insensitive";
    private final RepositoryManagerRESTAdapter repoAdapter;
    private final Map<String, String> searchParams;
    private final Map<String, String> assetSearchParams;
    private final Map<String, ElasticSearchContribution> searchContributions;
    private final Map<String, BlankValueSearchQueryFilter> filterAttributes;
    private final ElasticSearchContribution defaultElasticSearchContribution;
    private final ElasticSearchContribution blankValueElasticSearchContribution;

    @Inject
    public ElasticSearchUtils(RepositoryManagerRESTAdapter repoAdapter, Map<String, SearchMappings> searchMappings, Map<String, ElasticSearchContribution> searchContributions, Map<String, BlankValueSearchQueryFilter> filterAttributes) {
        this.repoAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repoAdapter);
        this.searchParams = ((Map)Preconditions.checkNotNull(searchMappings)).entrySet().stream().flatMap(e -> StreamSupport.stream(((SearchMappings)e.getValue()).get().spliterator(), true)).collect(Collectors.toMap(SearchMapping::getAlias, SearchMapping::getAttribute));
        this.assetSearchParams = this.searchParams.entrySet().stream().filter((? super T e) -> ((String)e.getValue()).startsWith(ASSET_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.searchContributions = (Map)Preconditions.checkNotNull(searchContributions);
        this.filterAttributes = (Map)Preconditions.checkNotNull(filterAttributes);
        this.defaultElasticSearchContribution = (ElasticSearchContribution)Preconditions.checkNotNull((Object)searchContributions.get("default"));
        this.blankValueElasticSearchContribution = (ElasticSearchContribution)Preconditions.checkNotNull((Object)searchContributions.get("blankValueContribution"));
    }

    private Map<String, String> getAssetSearchParameters() {
        return this.assetSearchParams;
    }

    public Repository getRepository(String repository) {
        return this.repoAdapter.getRepository(repository);
    }

    public Repository getReadableRepository(String repository) {
        return this.repoAdapter.getReadableRepository(repository);
    }

    public QueryBuilder buildQuery(Collection<SearchFilter> searchFilters) {
        return this.buildQuery(searchFilters, true);
    }

    public QueryBuilder buildQuery(Collection<SearchFilter> searchFilters, boolean conjunction) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        Consumer<QueryBuilder> contribute = conjunction ? arg_0 -> ((BoolQueryBuilder)query).must(arg_0) : arg_0 -> ((BoolQueryBuilder)query).should(arg_0);
        searchFilters.stream().filter((? super T searchFilter) -> !Strings2.isBlank((String)searchFilter.getValue())).sorted(Comparator.comparing(SearchFilter::getProperty).thenComparing(SearchFilter::getValue)).forEach(searchFilter -> {
            ElasticSearchContribution elasticSearchContribution = this.searchContributions.getOrDefault(searchFilter.getProperty(), this.defaultElasticSearchContribution);
            elasticSearchContribution.contribute(contribute, searchFilter.getProperty(), searchFilter.getValue());
        });
        this.handleBlankValueFilters(contribute, searchFilters);
        this.log.debug("Query: {}", (Object)query);
        return query;
    }

    private void handleBlankValueFilters(Consumer<QueryBuilder> contribute, Collection<SearchFilter> searchFilters) {
        searchFilters.stream().filter(this::filter).forEach(filter -> this.blankValueElasticSearchContribution.contribute(contribute, filter.getProperty(), filter.getValue()));
    }

    private boolean filter(SearchFilter filter) {
        BlankValueSearchQueryFilter queryFilter = this.filterAttributes.get(filter.getProperty());
        return queryFilter != null ? queryFilter.shouldHandleBlankValue() : Strings2.isBlank((String)filter.getValue());
    }

    public QueryBuilder buildQuery(UriInfo uriInfo) {
        Collection<SearchFilter> searchFilters = this.convertParameters(uriInfo, Arrays.asList(CONTINUATION_TOKEN, SORT_FIELD, SORT_DIRECTION));
        return this.buildQuery(searchFilters);
    }

    public QueryBuilder buildQuery(UriInfo uriInfo, List<String> parameters) {
        ArrayList<String> filterParameters = new ArrayList<String>();
        filterParameters.add(CONTINUATION_TOKEN);
        filterParameters.add(SORT_FIELD);
        filterParameters.add(SORT_DIRECTION);
        filterParameters.addAll(parameters);
        return this.buildQuery(this.convertParameters(uriInfo, filterParameters));
    }

    private Collection<SearchFilter> convertParameters(UriInfo uriInfo, List<String> keys) {
        return uriInfo.getQueryParameters().entrySet().stream().filter((? super T entry) -> !keys.contains(entry.getKey())).map(entry -> ((List)entry.getValue()).stream().map(value -> {
            String key = this.searchParams.getOrDefault(entry.getKey(), (String)entry.getKey());
            return new SearchFilter(key, (String)value);
        }).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @VisibleForTesting
    boolean isFullAssetAttributeName(String assetSearchParam) {
        return assetSearchParam.startsWith(ASSET_PREFIX);
    }

    public String getFullAssetAttributeName(String key) {
        return this.isFullAssetAttributeName(key) ? key : this.getAssetSearchParameters().get(key);
    }

    public List<SortBuilder> getSortBuilders(String sort, String direction) {
        return this.getSortBuilders(sort, direction, true);
    }

    private List<SortBuilder> getSortBuilders(String sort, String direction, boolean allowAnySort) {
        if (sort == null) {
            return Collections.emptyList();
        }
        switch (sort) {
            case "group": {
                return this.handleGroupSort(direction);
            }
            case "name": {
                return this.handleNameSort(direction);
            }
            case "version": {
                return this.handleVersionSort(direction);
            }
            case "repositoryName": 
            case "repository": {
                return this.handleRepositoryNameSort(direction);
            }
        }
        return this.handleOtherSort(sort, direction, allowAnySort);
    }

    private List<SortBuilder> handleGroupSort(String direction) {
        return Arrays.asList(SortBuilders.fieldSort((String)"group.case_insensitive").order(this.getValidSortOrder(direction, SortOrder.ASC)), SortBuilders.fieldSort((String)"name.case_insensitive").order(SortOrder.ASC), SortBuilders.fieldSort((String)"version").order(SortOrder.ASC));
    }

    private List<SortBuilder> handleNameSort(String direction) {
        return Arrays.asList(SortBuilders.fieldSort((String)"name.case_insensitive").order(this.getValidSortOrder(direction, SortOrder.ASC)), SortBuilders.fieldSort((String)"version").order(SortOrder.ASC), SortBuilders.fieldSort((String)"group.case_insensitive").order(SortOrder.ASC));
    }

    private List<SortBuilder> handleRepositoryNameSort(String direction) {
        return Collections.singletonList(SortBuilders.fieldSort((String)"repository_name").order(this.getValidSortOrder(direction, SortOrder.ASC)));
    }

    private List<SortBuilder> handleVersionSort(String direction) {
        return Collections.singletonList(SortBuilders.fieldSort((String)"normalized_version").order(this.getValidSortOrder(direction, SortOrder.DESC)));
    }

    private List<SortBuilder> handleOtherSort(String sort, String direction, boolean allowed) {
        if (!allowed) {
            return Collections.emptyList();
        }
        return Collections.singletonList(SortBuilders.fieldSort((String)sort).order(this.getValidSortOrder(direction, SortOrder.ASC)));
    }

    private SortOrder getValidSortOrder(String direction, SortOrder defaultValue) {
        block14: {
            if (direction == null) break block14;
            switch (direction.toLowerCase()) {
                case "ascending": 
                case "asc": {
                    return SortOrder.ASC;
                }
                case "descending": 
                case "desc": {
                    return SortOrder.DESC;
                }
            }
        }
        return defaultValue;
    }

    public QueryBuilder buildQuery(SearchRequest searchRequest) {
        QueryBuilder queryBuilder = this.buildQuery(searchRequest.getSearchFilters(), searchRequest.isConjunction());
        List<SortBuilder> sortBuilders = this.getSortBuilders(searchRequest.getSortField(), searchRequest.getSortDirection() != null ? searchRequest.getSortDirection().name() : null);
        RepositoryQueryBuilder repositoryQueryBuilder = RepositoryQueryBuilder.repositoryQuery(queryBuilder).sortBy(sortBuilders);
        if (searchRequest.getRepositories() != null && !searchRequest.getRepositories().isEmpty()) {
            repositoryQueryBuilder.inRepositories(searchRequest.getRepositories());
        }
        if (!searchRequest.isCheckAuthorization()) {
            repositoryQueryBuilder.unrestricted();
        }
        return repositoryQueryBuilder;
    }
}

