/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.normalize;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;

public class VersionNumberExpander {
    private static final String NUMBER_FORMAT = "%09d";
    public static final Logger log = Loggers.getLogger(VersionNumberExpander.class);

    private VersionNumberExpander() {
    }

    public static String expand(String version) {
        if (StringUtils.isBlank((String)version)) {
            return "";
        }
        Matcher matcher = Pattern.compile("\\d+").matcher(version);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(result, String.format(NUMBER_FORMAT, Long.parseLong(matcher.group())));
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Unable to parse number as long '{}'", (Object)matcher.group());
                matcher.appendReplacement(result, matcher.group());
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

